// 
// 
// Opis: Prosty odbiornik komunikatow umieszczajacy
// kazda otrzymana wiadomosc w linii w obiekcie TMemo.
// 
//

unit PipeChildMain;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QExtCtrls, QTypes, Libc;

type
  TPipeChildMainForm = class(TForm)
    Panel1: TPanel;
    MsgMemo: TMemo;
    ExitBtn: TButton;
    procedure ReadPipe;
    procedure FormCreate(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
  private
    { Deklaracje prywatne }
  public
    { Deklaracje publiczne }
  end;

const
 StrIndexLen = 4;
 LF = ^J; { linefeed/newline w ASCII }
   
var
  PipeChildMainForm: TPipeChildMainForm;
  ParentReadPipe : Integer;
  SigActionRec : TSigAction;

implementation

{$R *.xfm}

procedure Handler(Sig : Integer); cdecl;
begin
 case Sig of
  SIGUSR1 : PipeChildMainForm.ReadPipe;
 end; { case }
end;

procedure InstallHandler;
begin
 with SigActionRec do
  begin
   __sigaction_handler := Handler;
   sigemptyset(sa_mask);
   sa_flags := 0;
   sigaction(SIGUSR1, @SigActionRec, nil);
  end; { with }
end;

procedure TPipeChildMainForm.ReadPipe;
var
 ReadBuf : array[0..BUFSIZ] of Char;
 s : String;
 len : Integer;
begin
 { odczytujemy dlugosc lancucha }
 __read(ParentReadPipe, ReadBuf, StrIndexLen);
 ReadBuf[StrIndexLen] := chr(0);
 len := StrToInt(ReadBuf);

 { pobieramy lancuch } 
 __read(ParentReadPipe, ReadBuf, len);
 ReadBuf[len] := chr(0);
 s := ReadBuf;
 MsgMemo.Lines.Add(s);
end;

procedure TPipeChildMainForm.FormCreate(Sender: TObject);
begin
 InstallHandler;
 ParentReadPipe := StrToInt(ParamStr(1));
end;

procedure TPipeChildMainForm.ExitBtnClick(Sender: TObject);
begin
 Close;
end;

end.
