// 
// 
// Opis: Konczy dzialajace kopie programu CrashTestDummy
// i usuwa powstale w wyniku procesy zombie.
// 
//

unit KillZombiesMain;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QExtCtrls, Libc, QTypes;

type
  TKillAllZombiesForm = class(TForm)
    LaunchBtn: TButton;
    ExitBtn: TButton;
    BehaviorRBGroup: TRadioGroup;
    Label1: TLabel;
    MonitorTimer: TTimer;
    procedure RefreshForm;
    procedure ExitBtnClick(Sender: TObject);
    procedure LaunchBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure BehaviorRBGroupClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure MonitorTimerTimer(Sender: TObject);
  private
    { Deklaracje prywatne }
  public
    { Deklaracje publiczne }
  end;

const
 LF = ^J; { linefeed/newline w ASCII }
var
  KillAllZombiesForm: TKillAllZombiesForm;
  SigActionRec : TSigAction;
  ChildDone : Boolean;
  ChildPID : pid_t;

implementation

{$R *.xfm}

procedure Handler(Sig : Integer); cdecl;
begin
 case Sig of
  SIGCHLD : begin
             if waitpid(ChildPID, nil, WNOHANG) = ChildPID
              then ChildDone := True;
            end;
 end; { case }
end;

procedure InstallHandlers;
begin
 with SigActionRec do
  begin
   __sigaction_handler := Handler;
   sigemptyset(sa_mask);
   sa_flags := 0;
   sigaction(SIGCHLD, @SigActionRec, nil);
  end; { with }
end;

procedure DefaultHandlers;
begin
 with SigActionRec do
  begin
   __sigaction_handler := TSigActionHandler(SIG_DFL);
   sigemptyset(sa_mask);
   sa_flags := 0;
   sigaction(SIGCHLD, @SigActionRec, nil);
  end; { with }
end;

procedure TKillAllZombiesForm.RefreshForm;
begin
 case BehaviorRBGroup.ItemIndex of
  0 : InstallHandlers;
  1 : DefaultHandlers;
 end; { case }
end;

procedure TKillAllZombiesForm.LaunchBtnClick(Sender: TObject);
var
 i : Integer;
 FName : String;
 HomeDir : String;
 argv : array[0..1] of PChar;
 open_max : Integer;

begin
 HomeDir := getenv('HOME') +'/';
 FName := HomeDir + 'CrashTestDummy';
 argv[0] := PChar(FName);
 argv[1] := nil;

 if not FileExists(FName)
  then begin
        MessageDlg('Blad', 'Nie odnaleziono pliku ' + FName + '.' + LF
         + 'Upewnij sie ze wystepuje on w twojej ' + LF
         + 'domowej kartotece.',
         mtError, [mbOK], 0);
        Exit;
       end;

 ChildPID := fork;
 case ChildPID of
  -1 : { to jest wciaz proces nadrzedny }
       MessageDlg('Blad', 'Nie mozna uruchomic procesu potomnego.',
        mtError, [mbOK], 0);
        
   0 : begin { to jest proces potomny }
        { zamykamy otwarte pliki }
        open_max := sysconf(_SC_OPEN_MAX);
        for i := stderr + 1 to open_max - 1 do
         fcntl(i, F_SETFD, FD_CLOEXEC);

        execlp(PChar(FName), @argv, nil);

        { gdy execlp sie nie powiedzie, konczymy proces potomny }
        __exit(EXIT_FAILURE);
       end;
  else { to jest proces nadrzedny wiec wylaczamy przycisk }
   LaunchBtn.Enabled := False;
   ChildDone := False;
   MonitorTimer.Enabled := True; 
 end { case }
end;

procedure TKillAllZombiesForm.MonitorTimerTimer(Sender: TObject);
begin
 if ChildDone
  then begin
        MonitorTimer.Enabled := False;
        ShowMessage('Proces potomny zakonczony.');
        LaunchBtn.Enabled := True;
       end;
end;

procedure TKillAllZombiesForm.ExitBtnClick(Sender: TObject);
begin
 Close;
end;

procedure TKillAllZombiesForm.FormActivate(Sender: TObject);
begin
 Label1.Caption := 'Process ID: ' + IntToStr(getpid);
end;

procedure TKillAllZombiesForm.BehaviorRBGroupClick(Sender: TObject);
begin
 RefreshForm;
end;

procedure TKillAllZombiesForm.FormCreate(Sender: TObject);
begin
 RefreshForm;
end;

end.
