//
//
// Opis: Ilustruje uzyskiwanie informacji od systemu plikw proc
//
//
unit frmProcto;

interface

uses
  SysUtils, Libc, Types, Classes,
  QGraphics, QControls, QForms, QDialogs, QComCtrls,
  QStdCtrls, QExtCtrls,
  Procs;

type

  TfrmProctoMain = class(TForm)
    lvProcs: TListView;
    Splitter1: TSplitter;
    mmProcInfo: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure lvProcsSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
  private
    procedure EnumProcess (pid : __pid_t);
    procedure EnumFile (pid: __pid_t; fd: Integer);
  public
    { Public declarations }
  end;

var
  frmProctoMain: TfrmProctoMain;

implementation

{$R *.xfm}

procedure TfrmProctoMain.FormCreate(Sender: TObject);
begin
  lvProcs.Items.Clear;

  EnumProcesses (EnumProcess);
end;

procedure TfrmProctoMain.EnumProcess (pid: __pid_t);
var
  lItem : TListItem;
begin
  lItem := lvProcs.Items.Add;
  lItem.Caption := IntToStr (pid);
  lItem.SubItems.Add (ProcGetName (pid));
  lItem.SubItems.Add (ProcGetCmdline (pid));
end;

procedure TfrmProctoMain.EnumFile (pid: __pid_t; fd: Integer);
begin
  mmProcInfo.Lines.Add (Format ('%d = %s', [fd, ProcGetFD (pid, fd)]));
end;

procedure TfrmProctoMain.lvProcsSelectItem(Sender: TObject;
  Item: TListItem; Selected: Boolean);
var
  pid : __pid_t;
  info : TProcStat;
  s : String;
  i : Integer;
  lst : TStringList;
begin
  if not Selected then
    exit;
  pid := StrToInt (Item.Caption);
  mmProcInfo.Lines.BeginUpdate;
  try
    mmProcInfo.Clear;
    mmProcInfo.Lines.Add (Format ('Process ID = %d', [pid]));
    // display contents of Status file
    mmProcInfo.Lines.Add (ProcGetStatus (pid));

    // display files list
    mmProcInfo.Lines.Add ('Files');
    mmProcInfo.Lines.Add ('-----');
    ProcEnumFiles (pid, EnumFile);

    // Working dir, exe, and root dir
    mmProcInfo.Lines.Add ('');
    mmProcInfo.Lines.Add ('cwd = ' + ProcGetCwd (pid));
    mmProcInfo.Lines.Add ('exe = ' + ProcGetExe (pid));
    mmProcInfo.Lines.Add ('root = ' + ProcGetRoot (pid));

    // get stat file into record
    info := ProcGetStat (pid);
    // display name and status
    mmProcInfo.Lines.Add ('');
    mmProcInfo.Lines.Add ('stat');
    mmProcInfo.Lines.Add ('----');
    mmProcInfo.Lines.Add (info.comm);
    case info.state of
      'R' : s := 'Running';
      'S' : s := 'Sleeping (interruptible)';
      'D' : s := 'Sleeping (uninterruptible)';
      'Z' : s := 'Zombie';
      'T' : s := 'Stopped';
      else
        s := 'Unknown state';
    end;
    mmProcInfo.Lines.Add ('State = ' + s);

    // environment
    mmProcInfo.Lines.Add('');
    mmProcInfo.Lines.Add('Environment');
    mmProcInfo.Lines.Add('-----------');
    lst := ProcGetEnvironment (pid);
    if lst <> nil then
      try
        for i := 0 to lst.Count-1 do
          mmProcInfo.Lines.Add (lst[i]);
      finally
        lst.Free;
      end;

    // position to top of memo box
    mmProcInfo.SelStart := 1;
    mmProcInfo.SelLength := 0;
  finally
    mmProcInfo.Lines.EndUpdate;
  end;
end;

end.

