//
//
// Opis: Demonstruje tworzenie procesow potomnych z aplikacji GUI
//
//
unit frmFork;

interface

uses
  SysUtils, Libc, Types, Classes, QGraphics, QControls,
  QForms, QDialogs, QStdCtrls;

type
  TfrmForkMain = class(TForm)
    lblParent: TLabel;
    btnFork: TButton;
    lblProcessID: TLabel;
    Memo1: TMemo;
    btnExit: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btnForkClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
  private
  public
  end;

var
  frmForkMain: TfrmForkMain;

implementation

{$R *.xfm}


procedure TfrmForkMain.FormCreate(Sender: TObject);
begin
  lblProcessID.Caption := Format ('Process ID = %d', [getpid]);
end;

procedure TfrmForkMain.btnForkClick(Sender: TObject);
var
  forkRslt : __pid_t;
begin
  forkRslt := fork;
  if forkRslt = 0 then
  begin
    // to jest proces potomny
    lblParent.Caption := Format ('Proces potomny procesu %d', [getppid]);
  end
  else if forkRslt > 0 then
  begin
    // Rozgalezienie sie powiodlo. Rezultatem jest identyfikator
	// procesu potomnego
    Memo1.Lines.Add (Format ('Uruchomiony proces potomny %d', [forkRslt]));
  end
  else
  begin
    // wynik ujemny oznacza niepowodzenie funkcji fork
    Memo1.Lines.Add (Format ('Blad %d uruchamiania procesu potomnego', [forkRslt]));
  end;
end;

procedure TfrmForkMain.btnExitClick(Sender: TObject);
begin
GetModuleName (1);
  Close;
end;

end.
