//
//         execXXX functions Demo Program
//          frmExec.pas : Main Form
//           Developed by Jim Mischel
//
// Opis: Demonstruje uzycie rodziny funkcji execXXX
//
// Written for "Kylix Power Solutions"
// Copyright (c) 2001, Coriolis Group Books
//       Last revised 08 June 2001
//
unit frmExec;

interface

uses
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QExtCtrls, Libc;

type
  TfrmExecMain = class(TForm)
    rgFunction: TRadioGroup;
    edCmdLine: TEdit;
    Label1: TLabel;
    mmEnvironment: TMemo;
    Label2: TLabel;
    btnGo: TButton;
    btnExit: TButton;
    lblProcID: TLabel;
    procedure rgFunctionClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnGoClick(Sender: TObject);
  private
    FSaveEnv : string;
    bSaveEnv : boolean;
    FSaveArgs : string;
    bSaveArgs : boolean;
    procedure FunctionChanged;
    procedure FillEnvironmentMemo;
    function  CreateEnvArray: PPChar;
  end;

var
  frmExecMain: TfrmExecMain;

implementation

{$R *.xfm}

{
  Identyfikatory funkcji dla kontrolek:
  0 = execv
  1 = execve
  2 = execvp
  3 = execl
  4 = execle
  5 = execlp
  6 = fexecve
}
type
  TEnableRec = record
    bArgs : boolean;
    bEnv  : boolean;
  end;

const
  bEnableFlags : array [0..6] of TEnableRec =
  (
    (bArgs: true; bEnv: false),  // execv
    (bArgs: true; bEnv: true),   // execve
    (bArgs: true; bEnv: false),  // execvp
    (bArgs: false; bEnv: false), // execl
    (bArgs: false; bEnv: true),  // execle
    (bArgs: false; bEnv: false), // execlp
    (bArgs: true; bEnv: true)    // fexecve
  );

const
  DefaultProgramArgs = 'wywolywane przez execTest';
  DefaultEnv = 'OS=LINUX'^J'AUTHORS=Don,Jim,Tim'^J'TOOL=Kylix';

procedure TfrmExecMain.FormCreate(Sender: TObject);
begin
  lblProcID.Caption := Format ('Process ID = %d', [getpid]);
  FSaveEnv := DefaultEnv;
  bSaveEnv := bEnableFlags[rgFunction.ItemIndex].bEnv;
  FSaveArgs := DefaultProgramArgs;
  bSaveArgs := bEnableFlags[rgFunction.ItemIndex].bArgs;
  FunctionChanged;
end;

procedure TfrmExecMain.rgFunctionClick(Sender: TObject);
begin
  FunctionChanged;
end;

procedure TfrmExecMain.FillEnvironmentMemo;
var
  p : PPChar;
begin
  {
    Srodowisko jest przechowywane jako tablica lancuchow PChar
    z koncowym nil.
  }
  p := envp;
  while p^ <> nil do
  begin
    mmEnvironment.Lines.Add (p^);
    inc (p);
  end;
end;

procedure TfrmExecMain.FunctionChanged;
begin
  // aktualizuje pole edycji linii polecenia
  if bSaveArgs then
    FSaveArgs := edCmdLine.Text;
  bSaveArgs := bEnableFlags[rgFunction.ItemIndex].bArgs;
  if bSaveArgs then
    edCmdLine.Text := FSaveArgs
  else
    edCmdLine.Text := DefaultEnv;

  // aktualizuje pole srodowiska
  if bSaveEnv then
    FSaveEnv := mmEnvironment.Text;
  bSaveEnv := bEnableFlags[rgFunction.ItemIndex].bEnv;
  mmEnvironment.Lines.BeginUpdate;
  try
    mmEnvironment.Clear;
    if bSaveEnv then
      mmEnvironment.Text := FSaveEnv
    else
      FillEnvironmentMemo;
  finally
    mmEnvironment.Lines.EndUpdate;
  end;
  mmEnvironment.ReadOnly := not bSaveEnv;
end;

procedure TfrmExecMain.btnExitClick(Sender: TObject);
begin
  Close;
end;

// FreePCharArray - Zwalnia zaalokowane lancuchy oraz tablice
procedure FreePCharArray (var a : PPChar);
var
  p : PPChar;
begin
  if a = nil then
    exit;
  p := a;
  while p^ <> nil do
  begin
    StrDispose (p^);
    inc (p);
  end;
  FreeMem (a);
  a := nil;
end;

{
  CreatePCharArrayFromStrings
  Tworzy tablice wskaznikow PChar z otrzymanej listy TStrings.
  Ta funkcja alokuje pamiec dla wskaznikow PChar, kopiuje
  lancuchy z otrzymanej listy i umieszcza w tablicy wskazniki 
  do nowych lancuchow.
}
function CreatePCharArrayFromStrings (lst: TStrings): PPChar;
var
  a : PPChar;
  p : PPChar;
  i : Integer;
begin
  { AllocMem pre-inicjalizuje tablice wypelniajac ja zerami }
  a := AllocMem ((1+lst.Count)*Sizeof(PChar));
  try
    p := a;
    for i := 0 to lst.Count-1 do
    begin
      p^ := StrNew (PChar(lst[i]));
      inc (p);
    end;
    Result := a;
  except
    // przy wyjatku zwalniamy tablice i ponownie zglaszamy wyjatek
    FreePCharArray (a);
    raise;
  end;
end;

function CreateArgsArray (const sArgs: String): PPChar;
var
  lst : TStringList;
begin
  lst := TStringList.Create;
  try
    lst.CommaText := sArgs;
    Result := CreatePCharArrayFromStrings (lst);
  finally
    lst.Free;
  end;
end;

function TfrmExecMain.CreateEnvArray: PPChar;
var
  lst : TStringList;
  p : PPChar;
  i : Integer;
  sName : String;
begin
  {
    Tworzymy liste lancuchow zawierajaca wszystkie domyslne
	lancuchy srodowiska, po czym dodajemy lancuchy dostarczone
	przez uzytkownika.
  }
  lst := TStringList.Create;
  try
    // dodajemy do listy wszystkie domyslne lancuchy srodowiska
    p := envp;
    while p^ <> nil do
    begin
      lst.Add (p^);
      inc (p);
    end;

    // po czym dodajemy lancuchy z mmEnvironment
    // To zaktualizuje wszystkie duplikaty.
    for i := 0 to mmEnvironment.Lines.Count-1 do
    begin
      sName := mmEnvironment.Lines.Names[i];
      if sName <> '' then
        lst.Values[sName] := mmEnvironment.Lines.Values[sName];
    end;
    Result := CreatePCharArrayFromStrings (lst);
  finally
    lst.Free;
  end;
end;


procedure TfrmExecMain.btnGoClick(Sender: TObject);
const
  // argumenty programu uzywane przez funkcje z 'l'
  Args : array [0..3] of PChar =
    ('called', 'by', 'execTest', nil);
var
  pargs : PPChar;
  penv : PPChar;
  fd : integer;
begin
  pargs := nil;
  penv := nil;
  try
    if bEnableFlags[rgFunction.ItemIndex].bArgs then
      pargs := CreateArgsArray (edCmdLine.Text);
    if bEnableFlags[rgFunction.ItemIndex].bEnv then
      penv := CreateEnvArray;

    case rgFunction.ItemIndex of
      0 : execv  ('launched', pargs);
      1 : execve ('launched', pargs, penv);
      2 : execvp ('launched', pargs);
      // funkcje execl wymagaja parametrow jako argumentow funkcji
      3 : execl  ('launched', Args[0], Args[1], Args[2], nil);
      4 : execle ('launched', Args[0], Args[1], Args[2], nil, penv);
      5 : execlp ('launched',  Args[0], Args[1], Args[2], nil);
      6 :
      begin
        // otwieramy plik, po czym wywolujemy fexecve
        fd := Libc.open('launched', O_RDONLY);
        try
          if fd = -1 then
          begin
            ShowMessage ('Blad otwarcia pliku');
            exit;
          end;
          fexecve (fd, pargs, penv);
        finally
          Libc.__close (fd)
        end;
      end;
    end;
  finally
    FreePCharArray (pargs);
    FreePCharArray (penv);
  end;
  // wartosci dla errno sa w Libc.pas
  // Na przyklad: ENOSYS = 38
  ShowMessage (Format ('Blad %d uruchomienia programu', [errno]));
end;

end.

