// 
// 
// Opis: Demonstracja funkcji bibliotecznej sleep().
//
//

unit frmSleeper;

interface

uses
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs,
  QExtCtrls, QStdCtrls, Libc, QTypes;

type
  TSleeperMainForm = class(TForm)
    ExitBtn: TButton;
    StartBtn: TButton;
    SleepMemo: TMemo;
    TimerMemo: TMemo;
    Timer: TTimer;
    procedure SleepyBye;
    procedure ExitBtnClick(Sender: TObject);
    procedure StartBtnClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
  private
    { Deklaracje prywatne }
  public
    { Deklaracje publiczne }
  end;

var
  SleeperMainForm: TSleeperMainForm;

implementation

{$R *.xfm}

procedure TSleeperMainForm.SleepyBye;
var
 i : Integer;
 s : String;
begin
 Timer.Enabled := True;
 SleepMemo.Clear;
 TimerMemo.Clear;
 s := 'Start... ';
 SleepMemo.Text := s;

 for i := 1 to 4 do
  begin
   Application.ProcessMessages;
   __Sleep(5);
   s := s + IntToStr(i * 5);
   if i < 4
    then s := s + '... '
    else s := s + '!';
   SleepMemo.Text := s;
  end; { for }
end;

procedure TSleeperMainForm.ExitBtnClick(Sender: TObject);
begin
 Close;
end;

procedure TSleeperMainForm.StartBtnClick(Sender: TObject);
begin
 SleepyBye;
end;

procedure TSleeperMainForm.TimerTimer(Sender: TObject);
begin
 Timer.Enabled := False;
 TimerMemo.Text := 'Uruchomiono 12-sekundowy timer!';
end;

end.
