// 
// 
// Opis: Program demonstracyjny przedstawiajacy sposob jednokrotnego
// uruchomienia procesu zgodnie z ustalonym wczesniej harmonogramem.
// 
//

unit frmRunAt;

interface

uses
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QExtCtrls, Libc;

type
  TRunAtMainForm = class(TForm)
    ExitBtn: TButton;
    SchedBtn: TButton;
    BrowseDlg: TOpenDialog;
    SourceGroup: TGroupBox;
    FileNameEdit: TEdit;
    BrowseBtn: TButton;
    TextEdit: TEdit;
    FileRB: TRadioButton;
    TextRB: TRadioButton;
    TimeGroup: TGroupBox;
    AMRB: TRadioButton;
    PMRB: TRadioButton;
    HoursEdit: TEdit;
    MinsEdit: TEdit;
    Label1: TLabel;
    DayGroup: TGroupBox;
    TodayRB: TRadioButton;
    OtherRB: TRadioButton;
    MonthCombo: TComboBox;
    DayCombo: TComboBox;
    procedure RefreshFileDisplay;
    procedure RefreshTimeDisplay;
    procedure RefreshDayDisplay;
    function CreateCommandline(var Cmd : String;
                               var Parms : String) : Boolean;
    procedure WriteSchedule;
    procedure BrowseBtnClick(Sender: TObject);
    procedure FileRBClick(Sender: TObject);
    procedure TextRBClick(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AMRBClick(Sender: TObject);
    procedure PMRBClick(Sender: TObject);
    procedure TodayRBClick(Sender: TObject);
    procedure OtherRBClick(Sender: TObject);
    procedure SchedBtnClick(Sender: TObject);
  private
    { Deklaracje prywatne }
  public
    { Deklaracje publiczne }
  end;

const
 LF  = ^J; { linefeed/newline w ASCII }
 EOT = ^D; { znak konca pliku w ASCII}
 DefaultHour = 12;  { 12:00 Polnoc }
 DefaultMin  = 0;

var
  RunAtMainForm: TRunAtMainForm;
  HourVal : Integer;
  MinuteVal : Integer;

implementation

{$R *.xfm}

procedure ErrorMessage(Msg : String);
begin
 MessageDlg('Blad', Msg, mtError, [mbOK], 0);
end;
 
procedure TRunAtMainForm.RefreshFileDisplay;
begin
 if FileRB.Checked
  then begin
        FileNameEdit.Enabled := True;
        TextEdit.Enabled := False;
        BrowseBtn.Enabled := True;
       end
  else begin
        FileNameEdit.Enabled := False;
        TextEdit.Enabled := True;
        BrowseBtn.Enabled := False;
       end;
end;

procedure TRunAtMainForm.RefreshTimeDisplay;
var
 s : String;
begin
 HoursEdit.Text := IntToStr(HourVal);
 s := IntToStr(MinuteVal);
 if Length(s) < 2 then s := '0' + s;
 MinsEdit.Text := s;
end;

procedure TRunAtMainForm.RefreshDayDisplay;
begin
 if OtherRB.Checked
  then begin
        MonthCombo.Enabled := True;
        DayCombo.Enabled := True;
       end
  else begin
        MonthCombo.Enabled := False;
        DayCombo.Enabled := False;
       end;
end;

function TRunAtMainForm.CreateCommandline(var Cmd : String;
                                     var Parms : String) : Boolean;
begin
 Cmd := '';
 Parms := '';
 Result := False;

 { godziny }
 if (StrToInt(HoursEdit.Text) > 0) and (StrToInt(HoursEdit.Text) < 13)
  then Cmd := HoursEdit.Text + ':'
  else begin
        ErrorMessage('Niepoprawna wartosc godzin');
        Exit;
       end;

 { minuty }       
 if (StrToInt(MinsEdit.Text) >= 0) and (StrToInt(MinsEdit.Text) < 60)
  then Cmd := Cmd + MinsEdit.Text
  else begin
        ErrorMessage('Niepoprawna wartosc minut');
        Exit;
       end;

 { AM/PM }
 if AMRB.Checked
  then Cmd := Cmd + 'am '
  else Cmd := Cmd + 'pm ';

 { dzien/miesiac }
 if not TodayRB.Checked
  then begin
        Cmd := Cmd + MonthCombo.Items[MonthCombo.ItemIndex];
        Cmd := Cmd + ' ' + IntToStr(DayCombo.ItemIndex + 1) + ' ';
       end; 

 if FileRB.Checked
  then begin { przekazujemy wszystko do linii polecenia }
        if (Length(FileNameEdit.Text) > 0) and
           (FileExists(FileNameEdit.Text))
         then begin
               Cmd := Cmd + '< ' + FileNameEdit.Text;
              end
         else begin
               ErrorMessage('Podany plik nie istnieje');
               Exit;
              end;
       end
  else begin { reczne parametry przekazujemy osobno }
        Parms := TextEdit.Text;
       end;

 Result := True;
end;

procedure TRunAtMainForm.WriteSchedule;
const
 READ_IOMode = 'r'; { tryb odczytu z potoku }
 WRITE_IOMODE = 'w'; { tryb zapisu do potoku }
var
 Command : array[0..128] of char;
 CmdLineArr : array[0..512] of char;
 CmdLine : String;
 ParamArr : array[0..512] of char;
 Params : String;
 F : PIOFile;
 ErrNum : Integer;
begin
 CmdLine := '';
 Params := '';
 if CreateCommandline(CmdLine, Params)
  then begin
        if FileRB.Checked
         then begin { w linii polecenia przekazujemy nazwe pliku }
            errormessage(CmdLine);
               StrCopy(Command, 'at ');
               StrPCopy(CmdLineArr, CmdLine);
               StrCat(Command, CmdLineArr);

               F := popen(Command, READ_IOMode);
               ErrNum := pclose(F);
               if ErrNum <> -1
                then MessageDlg('Sukces', 'Zdarzenie zostalo umieszczone '
                      +'w harmonogramie', mtInformation, [mbOK], 0)
                else ErrorMessage('Napotkano blad podczas proby '
                      + 'zamkniecia potoku do programu "at"');
              end
         else begin { przekazujemy parametry poprzez stdin }
               StrCopy(Command, 'at ');
               StrPCopy(CmdLineArr, CmdLine);
               StrCat(Command, CmdLineArr);
               StrPCopy(ParamArr, Params);
               F := popen(Command, WRITE_IOMode);
               fputs(ParamArr, F);  { zapisujemy linie parametrow }
               fputc(ord(LF), F);   { zapisujemy znak nowej linii }
               fputc(ord(EOT), F);   { zapisujemy znak konca pliku }
               ErrNum := pclose(F);
               if ErrNum <> -1
                then MessageDlg('Sukces', 'Zdarzenie zostalo umieszczone '
                      +'w harmonogramie', mtInformation, [mbOK], 0)
                else ErrorMessage('Napotkano blad podczas proby '
                      + 'zamkniecia potoku do programu "at"');
              end;
       end
  else ErrorMessage('Nie poiodlo sie umieszczenie zdarzenia w harmonogramie');

end;

procedure TRunAtMainForm.BrowseBtnClick(Sender: TObject);
begin
 with BrowseDlg do
  begin
   if InitialDir = '' then InitialDir := '~';
   if Execute
    then FileNameEdit.Text := FileName;
  end; { with }
end;

procedure TRunAtMainForm.FileRBClick(Sender: TObject);
begin
 TextRB.Checked := not FileRB.Checked;
 RefreshFileDisplay;
end;

procedure TRunAtMainForm.TextRBClick(Sender: TObject);
begin
 FileRB.Checked := not TextRB.Checked;
 RefreshFileDisplay;
end;

procedure TRunAtMainForm.ExitBtnClick(Sender: TObject);
begin
 Close;
end;

procedure TRunAtMainForm.FormActivate(Sender: TObject);
begin
 RefreshFileDisplay;
 RefreshTimeDisplay;
 RefreshDayDisplay;
end;

procedure TRunAtMainForm.FormCreate(Sender: TObject);
begin
 HourVal := DefaultHour;
 MinuteVal := DefaultMin;
 MonthCombo.ItemIndex := 0;
 DayCombo.ItemIndex := 0;
end;

procedure TRunAtMainForm.AMRBClick(Sender: TObject);
begin
 PMRB.Checked := not AMRB.Checked;
end;

procedure TRunAtMainForm.PMRBClick(Sender: TObject);
begin
 AMRB.Checked := not PMRB.Checked;
end;

procedure TRunAtMainForm.TodayRBClick(Sender: TObject);
begin
 OtherRB.Checked := not TodayRB.Checked;
 RefreshDayDisplay;
end;

procedure TRunAtMainForm.OtherRBClick(Sender: TObject);
begin
 TodayRB.Checked := not OtherRB.Checked;
 RefreshDayDisplay;
end;

procedure TRunAtMainForm.SchedBtnClick(Sender: TObject);
begin
 WriteSchedule;
end;

end.
