// 
// 
// Opis: program demonstracyjny ilustrujcy selektywne zabijanie
// egzemplarzy procesw na podstawie ich nazwy.
// 
//

unit frmKiller;

interface

uses
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, Libc, ProcStuff;

type
  TfrmKillerMain = class(TForm)
    KillBtn: TButton;
    ExitBtn: TButton;
    Label1: TLabel;
    Label2: TLabel;
    procedure ExitBtnClick(Sender: TObject);
    procedure KillBtnClick(Sender: TObject);
  private
    { Deklaracje prywatne }
  public
    { Deklaracje publiczne }
  end;

const
 LF = ^J; { linefeed/newline w kodzie ASCII}
 PROCESSNAME = 'CrashTestDummy';

var
  frmKillerMain: TfrmKillerMain;

implementation

{$R *.xfm}

procedure TfrmKillerMain.ExitBtnClick(Sender: TObject);
begin
 Close;
end;

procedure TfrmKillerMain.KillBtnClick(Sender: TObject);
var
 i : Integer;
 L : TList;
 PRec : PProcInfoRec;
begin
 L := GetProcessListByName(PROCESSNAME);
 if L.Count > 0
  then for i := 0 to L.Count - 1 do
   begin
    PRec := L.Items[i];
    with PRec^ do
     if MessageDlg('Zabic proces? ',
         'Proces ' + IntToStr(i + 1) + ' of ' + IntToStr(L.Count)
          + LF + LF
         + 'Zabic ten proces?' + LF + LF
         + 'Process ID: ' + IntToStr(PID) + LF
         + 'Status: ' + Status + LF
         + 'Nazwa uzytkownika: ' + UName + LF
         + 'Polecenie: ' + CmdName + LF,
         mtConfirmation, [mbYes, mbNo], 0) = mrYes
     then kill(PID, SIGTERM);
   end { for }
   else ShowMessage('Nie znaleziono pasujacych pozycji dla ' + PROCESSNAME);

 L.Free;
end;

end.
