// Opis: Demonstruje uzycie zewnetrznych wspolnych bibliotek.
// 

unit Blowform;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, Blowfish, IdBaseComponent, IdCoder, IdCoder3To4;

type
  TForm1 = class(TForm)
    tbCleartext: TEdit;
    tbKey: TEdit;
    GroupBox1: TGroupBox;
	meClearOutput: TMemo;
    Label1: TLabel;
	Label2: TLabel;
    btnTest: TButton;
    btnExit: TButton;
    lblResult: TLabel;
    procedure btnTestClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
  private
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.xfm}

procedure TForm1.btnTestClick(Sender: TObject);
var
	key: PBF_KEY;
	cipherbytes, plainbytes, outputbytes: Array [0..1024] of Char;
	keystr, plainstr: String;
	curPos, origLen: Integer;
begin
	New( key );

		// zamiana na tablice znakow
	plainstr := tbCleartext.Text;
	strcopy( plainbytes, PChar( plainstr ) );
	origLen := Length( plainstr );

		// tworzymy klucz
	keystr := tbKey.Text;
	BF_set_key( key, Length( keystr ), PChar( keystr ) );

		// szyfrujemy, po dwa 4-bajtowe bloki naraz. W rzeczywistych aplikacjach
		// zastosowalibysmy dopelnianie (przychodzi na mysl dopelnianie PKCS #5),
		// ale to jest jedynie aplikacja testowa...
	curPos := 0;
	while ( curPos < origLen ) do
		begin
		BF_ecb_encrypt( @plainbytes[curPos], @cipherbytes[curPos], key, BF_ENCRYPT );
//		BF_ecb_encrypt( PChar( plainstr ), @cipherbytes, key, BF_ENCRYPT );
		curPos := curPos + 4;
		end;

		// i opis (ktory, wbrew pozorom, uzywa funkcji szyfrujacej)
	curPos := 0;
	while ( curPos < origLen ) do
		begin
		BF_ecb_encrypt( @cipherbytes[curPos], @outputbytes[curPos], key, BF_DECRYPT );
		curPos := curPos + 4;
		end;

		// zamieniamy bajty z powrotem na lancuch do wyswietlania i ustawiamy
		// dlugos (zwykle do okreslania dlugosci zostaloby uzyte dopelnianie)
	plainstr := plainbytes;
	SetLength( plainstr, origLen );

	meClearOutput.Lines.Add( plainstr );

	if ( plainstr = tbCleartext.Text ) then
		lblResult.Caption := 'Sukces!'
	else
		lblResult.Caption := 'Porazka!';

	Dispose( key );
end;

procedure TForm1.btnExitClick(Sender: TObject);
begin
	Close;
end;

end.

