//
// Program demonstracyjny wspolnego obiektu
// HelloDynmX.pas : Dynamiczny modul interfejsu dla roznych platform.
// Opracowany przez Jima Mischela
//
// Opis: Demonstruje uzycie bibliotek wspolnych plikow.
//
//
unit HelloDynmX;

interface

procedure SayHello;

implementation

uses SysUtils,
{$IFDEF LINUX}
  Libc
{$ELSE}
  Windows
{$ENDIF}
  ;

const
  {$IFDEF LINUX}
    STR_LIB_NAME = 'libhello.so.1';
    LibHandleNull = nil;
  {$ELSE}
    STR_LIB_NAME = 'sample';
    LibHandleNull = 0;
  {$ENDIF}

  // nazwy funkcji w bibliotece
  STR_HELLO_NAME = 'SayHello';

type
  {$IFDEF LINUX}
    TLibHandle = Pointer;
  {$ELSE}
    TLibHandle = HModule;
  {$ENDIF}

  HelloProc = procedure;
    {$IFDEF LINUX} cdecl; {$ELSE} stdcall; {$ENDIF}

var
  LibHandle : TLibHandle = LibHandleNull;

function GetLibraryHandle : TLibHandle;
begin
  if libHandle = libHandleNull then
  begin
    {$IFDEF LINUX}
      libHandle := dlopen (STR_LIB_NAME, RTLD_LAZY);
    {$ELSE}
      libHandle := LoadLibrary (STR_LIB_NAME);
    {$ENDIF}

    if libHandle = libHandleNull then
      raise Exception.CreateFmt
        ('Nie mozna otworzyc biblioteki "%s"', [STR_LIB_NAME]);
  end;
  Result := libHandle;
end;

function GetLibrarySymbol (const fName: String): Pointer;
var
  bErr : boolean;
begin
  {$IFDEF LINUX}
    dlerror; // wywolywane w celu wyczyszczenia kodu bledu
    Result := dlsym (GetLibraryHandle, PChar(fName));
    bErr := (dlerror <> nil);
  {$ELSE}
    Result := GetProcAddress (GetLibraryHandle, PChar(fName));
    bErr := (Result = nil);
  {$ENDIF}
  if bErr then
    raise Exception.CreateFmt
      ('Nie mozna znalezc symbolu "%s" w bibliotece "%s".',
        [STR_LIB_NAME, fName]);
end;

procedure SayHello;
const
  HelloPtr : HelloProc = nil;
begin
  if not Assigned (HelloPtr) then
    HelloPtr := GetLibrarySymbol (STR_HELLO_NAME);
  HelloPtr;
  dlClose (LibHandle);
  LibHandle := LibHandleNull;
end;

initialization
  // bez inicjalizacji--potrzebne dla finalizacji

finalization
  if libHandle <> LibHandleNull then
  begin
    {$IFDEF LINUX}
      if dlclose (libHandle) = -1 then
    {$ELSE}
      if not FreeLibrary (libHandle) then
    {$ENDIF}
        raise Exception.CreateFmt
          ('Blad zamykania biblioteki "%s".', [STR_LIB_NAME]);
  end;
end.
