# Laboratorium r17

## Konfiguracja

Wdróż aplikację Kube Explorer w konfiguracji laboratoryjnej:

```
kubectl apply -f lab/kube-explorer/
```

Zwróć uwagę, że [02-service-account.yaml](./kube-explorer/02-service-account.yaml) ustawia `automountServiceAccountToken` na `false`, aby kopsuły nie widziały tokena automatycznie; [04-deployment.yaml](./kube-explorer/04-deployment.yaml) mountuje token bezpośrednio w specyfikacji kapsuły.

> Otwórz aplikację i zobacz, że możesz uzyskać dostęp do kapsuł, np. http://localhost:8022

> Jednak nie do kapsuł z przestrzeni nazw lab – http://localhost:8022?ns=kiamol-ch17-lab

## Przykładowe rozwiązanie

Aby uzyskać dostęp do kapsuł z przestrzeni nazw lab, [rbac-pods.yaml](./solution/rbac-pods.yaml) stosuje do tej przestrzeni nazw ClusterRole `default-pod-reader-lab` :

```
kubectl apply -f lab/solution/rbac-pods.yaml
```

> Teraz możesz pracować z kapsułami z przestrzeni nazw lab – http://localhost:8022?ns=kiamol-ch17-lab

![Kube Explorer umożliwiający przeglądanie kapsuł z przestrzeni nazw lab](./solution/pods.png)

> Jednak nie kont usługi – http://localhost:8022/ServiceAccounts

Aby uzyskać dostęp do kont usługi, [rbac-serviceaccounts.yaml](./solution/rbac-serviceaccounts.yaml) tworzy:

- ClusterRole z dostępem get i list do kont usługi
- RoleBinding stosujący ClusterRole do przestrzeni nazw default
- RoleBinding stosujący ClusterRole do przestrzeni nazw lab

```
kubectl apply -f lab/solution/rbac-serviceaccounts.yaml
```

> Teraz możesz uzyskać dostęp do kapsuł w przestrzeniach nazw default i lab – http://localhost:8022/ServiceAccounts?ns=kiamol-ch17-lab

![Kube Explorer umożliwiający przeglądanie kont usług w przestrzeni nazw lab](./solution/service-accounts.png)

## Czyszczenie

Usuń wszystkie zasoby:

```
kubectl delete ns,rolebinding,role,clusterrole -l kiamol=ch17-lab
```
