# Laboratorium r08

Uruchom aplikację:

```
kubectl apply -f lab/nginx/
```

Pobierz adres URL i otwórz aplikację:

```
kubectl get svc nginx -o jsonpath='http://{.status.loadBalancer.ingress[0].*}:8088'
```

> Działa, ale jest to po prostu pojedyncza kapsuła zapisująca dzienniki w woluminie EmptyDir.

## Przykładowe rozwiązanie

Mój [StatefulSet](solution/nginx-statefulset.yaml) uruchamia trzy kapsuły, z szablonami żądań woluminów dla pamięci masowej.

```
kubectl apply -f lab/solution/nginx-statefulset.yaml
```

> Wywołaj aplikację wielokrotnie

W Powershellu użyłem tego:

```
for($i = 0; $i -lt 100; $i++) { curl http://localhost:8088 | Out-Null }
```

Następnie [Job](solution/disk-calc-job.yaml) został skonfigurowany do montowania wszystkich PVC użytych w kapsułach StatefulSet.

```
kubectl apply -f lab/solution/disk-calc-job.yaml
```

Gdy sprawdzam dzienniki, otrzymuję coś takiego:

```
PS>kubectl logs -l job-name=disk-calc
32.0K   /nginx0/access.log
24.0K   /nginx1/access.log
40.0K   /nginx2/access.log
```

## Czyszczenie

Usuń zasoby laboratorium na podstawie ich etykiet:

```
kubectl delete all -l kiamol=ch08-lab

kubectl delete pvc -l kiamol=ch08-lab
```
