# Laboratorium r19

## Konfiguracja

Wdróż metrics-server, jeśli go potrzebujesz (sprawdź za pomocą `kubectl top nodes` – brak statystyk oznacza, że go potrzebujesz):

```
kubectl apply -f metrics-server/
```

Uruchom aplikację:

```
kubectl apply -f lab/pi/
```

Sprawdź, czy napływają wskaźniki:

```
kubectl top pods -l app=pi-web-lab
```

> Otwórz aplikację i sprawdź okresy intensywniejszego użycia CPU, np. http://localhost:8032/?dp=100000

## Przykładowe rozwiązanie

Musisz oznaczyć węzeł, aby wskazać, że znajduje się w regionie EU – do tego celu możesz użyć klucza i wartości, ale musisz użyć tego samego w regułach powinowactwa:

```
kubectl label node --all kiamol.net/region=eu
```

### Kapsuła z regułami powinowactwa 

Aby zaktualizować wdrożenie w [solution/pi.yaml](./solution/pi.yaml) dodaj te ustawienia:

- **node affinity** – wymaga uruchamiania na węzłach z region=eu
- **pod anti-affinity** – preferuje uruchamianie na węzłach bez żadnych innych kapsuł Pi
- **resources** – dodaje żądanie pamięci, którego ma użyć HPA
- **replicas** – uruchamia z 2 replikami, które są pożądanym minimum

```
kubectl apply -f lab/solution/pi.yaml
```

> Będziesz miał uruchomione dwie kapsuły; otwórz aplikację w kilku kartach, a obie kapsuły będą miały wzmożone użycie CPU

### HPA do skalowania wg. CPU

Specyfikacja HPA w [solution/hpa-cpu.yaml](./solution/hpa-cpu.yaml) skaluje do 2 do 5 na podstawie docelowego wykorzystania 50% CPU.

```
kubectl apply -f lab/solution/hpa-cpu.yaml
```

> Wykonaj wiele żądań w różnych kartach przeglądarki (lub zastosuj skrypt `ch19/loadpi`). Zobaczysz, że kapsuły skalują się do maksymalnej liczby 5 replik:

![Poziome autoskalowanie kapsuł w działaniu](./solution/hpa.png)


## Czyszczenie

Usuń wszystkie zasoby:

```
kubectl delete all,hpa -l kiamol=ch19-lab
```

Usuń metrics-server, jeśli go wdrożyłeś:

```
kubectl delete -f metrics-server/
```