#!/bin/bash

tput setaf 3
echo -e "*******************************************************************************************************************"
echo -e "Tworzenie klastra KinD"
echo -e "*******************************************************************************************************************"

tput setaf 5
# Instalowanie kubectl.
echo -e "\n \n*******************************************************************************************************************"
echo -e "Krok 1. Instalowanie kubectl"
echo -e "*******************************************************************************************************************"
tput setaf 3
sudo snap install kubectl --classic

tput setaf 5
# Instalowanie Helm3 i jq.
echo -e "\n \n*******************************************************************************************************************"
echo -e "Krok 2. Instalowanie Helm3 i jq"
echo -e "*******************************************************************************************************************"
tput setaf 3
sudo snap install helm --classic
sudo snap install jq --classic

tput setaf 5
# Utworzenie klastra KIND o nazwie cluster01 na podstawie pliku konfiguracyjnego cluster01-kind.yaml.
echo -e "\n \n*******************************************************************************************************************"
echo -e "Krok 3. Utworzenie klastra KIND na podstawie pliku konfiguracyjnego cluster01-kind.yaml"
echo -e "*******************************************************************************************************************"
tput setaf 3
kind create cluster --name cluster01 --config cluster01-kind.yaml

tput setaf 5
# Instalowanie Calico.
echo -e "\n \n*******************************************************************************************************************"
echo -e "Krok 4. Instalowanie Calico z pliku lokalnego, używając 10.240.0.0/16 jako CIDR poda"
echo -e "*******************************************************************************************************************"
tput setaf 3
kubectl apply -f calico.yaml

# Wdrożenie NGINX.
tput setaf 5
echo -e "\n \n*******************************************************************************************************************"
echo -e "Krok 5. Instalowanie kontrolera NGINX Ingress"
echo -e "*******************************************************************************************************************"
tput setaf 3
kubectl apply -f https://raw.githubusercontent.com/kubernetes/ingress-nginx/nginx-0.28.0/deploy/static/mandatory.yaml
kubectl apply -f https://raw.githubusercontent.com/kubernetes/ingress-nginx/nginx-0.27.0/deploy/static/provider/baremetal/service-nodeport.yaml

# Konfiguracja NGINX w celu przekazywania ruchu sieciowego na portach 80 i 443.
tput setaf 5
echo -e "\n \n*******************************************************************************************************************"
echo -e "Krok 6. Modyfikacja wdrażenia NGINX w celu udostępnienia poda na portach HOSTA  80 i 443"
echo -e "*******************************************************************************************************************"
tput setaf 3
kubectl patch deployments -n ingress-nginx nginx-ingress-controller -p '{"spec":{"template":{"spec":{"containers":[{"name":"nginx-ingress-controller","ports":[{"containerPort":80,"hostPort":80},{"containerPort":443,"hostPort":443}]}]}}}}'

# Ustalenie adresu IP hosta Dockera.
tput setaf 3
hostip=$(hostname  -I | cut -f1 -d' ')
echo -e "\n \n*******************************************************************************************************************"
echo -e "Zakończenie tworzenia klastra.  Poniższe podsumowanie zawiera ważne informacje, które będą wykorzystane w późniejszych rozdziałach"
echo -e "*******************************************************************************************************************"

tput setaf 7
echo -e "\n \n*******************************************************************************************************************"
echo -e "Informacje o klastrze Kind: \n"
echo -e "Domena Ingress: $hostip.nip.io \n"
echo -e "Reguły Ingress będą używały adresu IP hosta Linuka w domenie \n"
echo -e "Przykład:  Masz serwer WWW, który chcesz udostepnić za pomocą hosta o nazwie ordering."
echo -e "           Reguła ingress będzie używała nazwy hosta: ordering.$hostip.nip.io"
echo -e "******************************************************************************************************************* \n"
