package k8sallowedregistries

violation[{"msg": msg, "details": {}}] {
  invalidRegistry
  msg := "Nieprawidłowy rejestr"
}


# Zwraca wartość true, jeśli nie został podany poprawny rejestr.
invalidRegistry {
  input_images[image]
  not startswith(image, "quay.io/")
}

# Wczytanie obrazów z obiektów pod.
input_images[image] {
  image := input.review.object.spec.containers[_].image
}

# Wczytanie obrazów z obiektów Deployment i StatefulSet.
input_images[image] {
  image := input.review.object.spec.template.spec.containers[_].image
}

# Wczytanie obrazów z obiektów CronJob.
# W rozdziale 11. usuń znaki komentarza z początku wierszy.
#input_images[image] {
#  image := input.review.object.spec.jobTemplate.spec.template.spec.containers[_].image
#}