# Kubernetes i Docker. Przewodnik po tworzeniu systemów korporacyjnych
  
Uwaga: nie dla wszystkich rozdziałów zostały przygotowane materiały dodatkowe. Dla rozdziałów 2., 3. i 5. nie ma żadnych ćwiczeń, więc nie znajdziesz tutaj przykładowych fragmentów kodu lub skryptów.

Uaktualnienia i errata dla książki zostały zamieszczone na stronie wiki pod adresem https://github.com/PacktPublishing/Kubernetes-and-Docker-The-Complete-Guide/wiki/_new
  
Witamy w materiałach dodatkowych dla wydanej przez Helion książki "Kubernetes i Docker. Przewodnik po tworzeniu systemów korporacyjnych", której autorami są Scott Surovich i Marc Boorshtein.
  
Te materiały zawierają skrypty, do których odwołania znajdują się w tekście książki. Umieść je w komputerze, który będzie używany do ćwiczeń zamieszczonych w rozdziałach.
W poszczególnych rozdziałach zostały omówione ważne fragmenty tych skryptów, więc sposób ich działania powinien być Ci znany. Wprawdzie te skrypty nie są wymagane, ale dzięki nim możesz uniknąć konieczności ręcznego wpisywania kodu manifestów.
  
Ćwiczenia zostały zamieszczone w rozdziałach 1. oraz od 5. do 14.  
W rozdziałach 2. i 3. znajdują się przykłady Dockera, które można wykonać we własnym hoście, choć nie jest to konieczne.
  
# Wymagane doświadczenie
Materiał zamieszczony w książce wymaga podstawowej znajomości Dockera i Kubernetes. W tekście znalazło się naprawdę wiele materiału i zabrakło już miejsca na dokładne omówienie tematów takich jak instalacja nowego klastra bądź przeznaczenie poszczególnych obiektów Kubernetes i ich sposób działania.
  
W rozdziałach od 1. do 3. znajduje się krótkie wprowadzenie do Dockera i jego najważniejszych funkcji, np. używanie systemu plików hosta i sieci hosta, niezbędnych do zrozumienia materiału zamieszczonego w książce. Z kolei rozdział 4. zawiera krótkie wprowadzenie do obiektów Kubernetes. Dokładne omówienie poszczególnych obiektów wymagałoby całej książki, a na ten temat napisano już ich wiele. Wspomniane krótkie wprowadzenie jest przeznaczone do początkujących czytelników lub tych, którzy chcą sobie odświeżyć wiedzę na ten temat.

# Wymagania sprzętowe
Ubuntu 18.04
4 GB pamięci RAM dla większości ćwiczeń, preferowane jest 8 GB RAM
5-10 GB  wolnego miejsca na dysku hosta Dockera

Uwaga: ćwiczenia zamieszczone w książce zostały przeznaczone dla dystrybucji Ubuntu 18.04, a ponadto były przetestowane również z wydaniami Ubuntu 16 i 18.
Wprawdzie większość tych ćwiczeń można prawidłowo wykonać w dowolnym systemie Linux, ale ćwczenia w rozdziale 12. mogą być wykonane nieprawidłwo w systemie innym niż Ubuntu.
Wszystkie pozostałe powinny bez problemów działać w dystrybucjach takich jak CentOS i Ubuntu.

Przetestowaliśmy podsystem WSL2 i Dockera, większość ćwiczeń działa prawidłowo. Natomiast w rozdziale 12. są budowane moduły dla jądra i obecnie te ćwiczenia nie działają w podsystemie WSL2.

# Ogólne omówienie zawartości książki
W książce znajduje się 14 rozdziałów, w których została omówiona szeroka gama tematów, począwszy od Dockera aż po opracowanie platformy. Napisaliśmy tę książkę, aby pomóc czytelnikom wykroczyć poza podstawy klastra Kubernetes. Skoncentrowaliśmy się na funkcjonalności przydatnej w korporacjach, takiej jak dodawanie działających na poziomie warstwy 4 mechanizmów równoważenia obciążenia dla usług z dynamiczną rejestracją nazw, integrowanie klastra z Active Directory (lub LDAP), zabezpieczanie panelu Kubernetes za pomocą RBAC i odwrotnego proxy, jak NIE powinno odbywać się zabezpianie panelu Kubernetes, wcielanie się w rolę Kubernetes, stosowanie polityk PSP i OPA do zabezpieczania klastra, przeprowadzanie audytu podów za pomocą narzędzia Falco zintegrowanego z EFK, tworzenie kopii zapasowej danych za pomocą Velero, a także opracowanie platformy z użyciem narzędzi Tekton i CI/CD tools.
