package rozdzial9;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.*;
import java.util.Arrays;

import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.internet.*;

import org.bouncycastle.mail.smime.SMIMESigned;

/**
 * Prosty przykad tworzenia i przetwarzania podpisanej wiadomoci e-mail z wieloczciow treci.
 */
public class SignedMultiPartMailExample
    extends SignedDataProcessor
{
    public static void main(
        String args[])
        throws Exception
    {
        KeyStore        credentials = Utils.createCredentials();
        PrivateKey      key = (PrivateKey)credentials.getKey(Utils.END_ENTITY_ALIAS, Utils.KEY_PASSWD);
        Certificate[]   chain = credentials.getCertificateChain(Utils.END_ENTITY_ALIAS);
        CertStore       certsAndCRLs = CertStore.getInstance("Collection",
                            new CollectionCertStoreParameters(Arrays.asList(chain)), "BC");
        X509Certificate cert = (X509Certificate)chain[0];

        // utworzenie podpisywanej wiadomoci
        MimeBodyPart    dataPart1 = new MimeBodyPart();

        dataPart1.setText("Hello ");

        MimeBodyPart    dataPart2 = new MimeBodyPart();

        dataPart2.setText("World!");

        MimeMultipart dataMultiPart = new MimeMultipart();

        dataMultiPart.addBodyPart(dataPart1);
        dataMultiPart.addBodyPart(dataPart2);

        MimeBodyPart bodyPart = new MimeBodyPart();

        //
        // Trzeba uwaa z ustawianiem dodatkowych nagwkw. Niektre klienty pocztowe
        // ignoruj na przykad pola To i From w czci zawierajcej wiadomo
        // wieloczciow. W takiej sytuacji podpis wiadomoci nie da si zweryfikowa.
        // Przykadem programu o takim zachowaniu jest Outlook Express.
        //
        bodyPart.setContent(dataMultiPart);
        
        // utworzenie podpisanej wiadomoci
        MimeMultipart multiPart = SignedMailExample.createMultipartWithSignature(key, cert, certsAndCRLs, bodyPart);

        // utworzenie wiadomoci e-mail
        MimeMessage body = Utils.createMimeMessage("przykladowa wiadomosc e-mail", multiPart, multiPart.getContentType());
body.writeTo(new java.io.FileOutputStream("test"));
        // pobranie treci z wiadomoci e-mail
        if (body.isMimeType("multipart/signed"))
        {
            SMIMESigned             signed = new SMIMESigned(
                                            (MimeMultipart)body.getContent());
            
            // weryfikacja
            X509Certificate rootCert = (X509Certificate)credentials.getCertificate(Utils.ROOT_ALIAS);
            
            if (isValid(signed, rootCert))
            {
                System.out.println("weryfikacja zakoczona powodzeniem");
            }
            else
            {
                System.out.println("weryfikacja nie powioda si");
            }
            
            // wywietlenie zawartoci
            MimeBodyPart  content = signed.getContent();
            Multipart     cont = (Multipart)content.getContent();

            int count = cont.getCount();
            for (int i = 0; i < count; i++)
            {
                BodyPart    m = cont.getBodyPart(i);
                Object      part = m.getContent();

                System.out.println("Cz " + i);
                System.out.println("----- pocztek -----");
                System.out.println(part);
                System.out.println("------ koniec ------");
            }
        }
    }
}
