package rozdzial9;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;

/**
 * Przykad ilustrujcy tworzenie i przetwarzanie koperty cyfrowej z odbiorc dla klucza publicznego
 * i porwnaniem ID odbiorcy z certyfikatem w celu upewnienia si, e mamy waciwego odbiorc.
 */
public class KeyTransEnvelopedDataWithCertMatchExample
{
    public static void main(String[] args)
        throws Exception
    {
        KeyStore        credentials = Utils.createCredentials();
        PrivateKey      key = (PrivateKey)credentials.getKey(Utils.END_ENTITY_ALIAS, Utils.KEY_PASSWD);
        Certificate[]   chain = credentials.getCertificateChain(Utils.END_ENTITY_ALIAS);
        X509Certificate cert = (X509Certificate)chain[0];

        // przygotowanie generatora
        CMSEnvelopedDataGenerator gen = new CMSEnvelopedDataGenerator();

        gen.addKeyTransRecipient(cert);

        // utworzenie koperty cyfrowej
        CMSProcessable   data = new CMSProcessableByteArray("Hello World!".getBytes());

        CMSEnvelopedData enveloped = gen.generate(
                                data,
                                CMSEnvelopedDataGenerator.AES256_CBC, "BC");
        
        // odtworzenie
        enveloped = new CMSEnvelopedData(enveloped.getEncoded());
        
        // przygotowanie do przejcia po kolejnych odbiorcach
        RecipientInformationStore   recipients = enveloped.getRecipientInfos();
        CertStore                   certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(Collections.singleton(cert)), "BC");
        Iterator                    it = recipients.getRecipients().iterator();
        RecipientInformation        recipient = null;
        
        while (it.hasNext())
        {
            recipient = (RecipientInformation)it.next();
            if (recipient instanceof KeyTransRecipientInformation)
            {
                // dopasowanie ID odbiorcy
                Collection matches = certStore.getCertificates(recipient.getRID());
                
                if (!matches.isEmpty())
                {
                    // deszyfrowanie danych
                    byte[] recData = recipient.getContent(key, "BC");

                    // porwnanie danych odtworzonych z oryginalnymi
                    if (Arrays.equals((byte[])data.getContent(), recData))
                    {
                        System.out.println("dane odtworzone pomylnie");
                        break;
                    }
                    else
                    {
                        System.out.println("odtwarzanie danych zakoczone niepowodzeniem");
                        break;
                    }
                }
            }
        }   
        
        if (recipient == null)
        {
            System.out.println("nie znaleziono pasujcego odbiorcy");
        }
    }
}