package rozdzial9;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.*;
import java.util.Arrays;

import javax.mail.internet.*;

import org.bouncycastle.cms.*;
import org.bouncycastle.mail.smime.*;

/**
 * Prosty przykad tworzcy i przetwarzajcy podpisan wiadomo e-mail zawierajc kopert cyfrow.
 */
public class EnvelopedSignedMailExample
    extends SignedDataProcessor
{
    public static void main(
        String[] args)
        throws Exception
    {
        KeyStore        credentials = Utils.createCredentials();
        PrivateKey      key = (PrivateKey)credentials.getKey(Utils.END_ENTITY_ALIAS, Utils.KEY_PASSWD);
        Certificate[]   chain = credentials.getCertificateChain(Utils.END_ENTITY_ALIAS);
        CertStore       certsAndCRLs = CertStore.getInstance("Collection",
                            new CollectionCertStoreParameters(Arrays.asList(chain)), "BC");
        X509Certificate cert = (X509Certificate)chain[0];

        // utworzenie wiadomoci do podpisania
        MimeBodyPart    dataPart = new MimeBodyPart();

        dataPart.setText("Hello world!");

        // utworzenie podpisanej wiadomoci
        MimeMultipart signedMultipart = SignedMailExample.createMultipartWithSignature(key, cert, certsAndCRLs, dataPart);

        // utworzenie czci zawierajcej podpisan wiadomo
        MimeBodyPart signedPart = new MimeBodyPart();

        signedPart.setContent(signedMultipart);

        // przygotowanie generatora kopert cyfrowych
        SMIMEEnvelopedGenerator  gen = new SMIMEEnvelopedGenerator();

        gen.addKeyTransRecipient(cert);

        // wygenerowanie koperty cyfrowej
        MimeBodyPart envPart = gen.generate(signedPart, SMIMEEnvelopedGenerator.AES256_CBC, "BC");

        // utworzenie wiadomoci e-mail
        MimeMessage mail = Utils.createMimeMessage("przykadowa podpisana wiadomo kopertowa", envPart.getContent(), envPart.getContentType());

        // utworzenie obiektu koperty na podstawie wiadomoci e-mail
        SMIMEEnveloped     enveloped = new SMIMEEnveloped(mail);
        
        // wyszukanie identyfikatora odbiorcy
        RecipientId        recId = new RecipientId();

        recId.setSerialNumber(cert.getSerialNumber());
        recId.setIssuer(cert.getIssuerX500Principal().getEncoded());

        RecipientInformationStore   recipients = enveloped.getRecipientInfos();
        RecipientInformation        recipient = recipients.get(recId);

        // deszyfrowanie
        MimeBodyPart        res = SMIMEUtil.toMimeBodyPart(recipient.getContent(key, "BC"));

        // wyodrbnienie obiektu wiadomoci wieloczciowej z treci wiadomoci
        if (res.getContent() instanceof MimeMultipart)
        {
            SMIMESigned     signed = new SMIMESigned(
                                            (MimeMultipart)res.getContent());

            // weryfikacja
            X509Certificate rootCert = (X509Certificate)credentials.getCertificate(Utils.ROOT_ALIAS);
            
            if (isValid(signed, rootCert))
            {
                System.out.println("weryfikacja zakoczona powodzeniem");
            }
            else
            {
                System.out.println("weryfikacja zakoczona niepowodzeniem");
            }
            
            // wywietlenie zawartoci
            MimeBodyPart            content = signed.getContent();

            System.out.print("Zawarto: ");
            System.out.println(content.getContent());
        }
        else
        {
            System.out.println("nieprawidowa zawarto");
        }
    }
}