package rozdzial9;

import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;

import org.bouncycastle.mail.smime.SMIMECompressed;
import org.bouncycastle.mail.smime.SMIMECompressedGenerator;
import org.bouncycastle.mail.smime.SMIMEUtil;

/**
 * Prosty przykad tworzenia i przetwarzania skompresowanej wiadomoci e-mail.
 */
public class CompressedMailExample
{
    public static void main(
        String args[])
        throws Exception
    {
        // utworzenie wiadomoci do skompresowania
        MimeBodyPart    dataPart = new MimeBodyPart();

        dataPart.setText("Hello world!");
        
        // przygotowanie generatora
        SMIMECompressedGenerator  gen = new SMIMECompressedGenerator();

        // wygenerowanie skompresowanej wiadomoci
        MimeBodyPart comPart = gen.generate(dataPart, SMIMECompressedGenerator.ZLIB);

        // utworzenie wiadomoci pocztowej
        MimeMessage mail = Utils.createMimeMessage("przykladowa skompresowana wiadomosc", comPart.getContent(), comPart.getContentType());

        // odtworzenie skompresowanego obiektu z wiadomoci e-mail
        SMIMECompressed  compressed = new SMIMECompressed(mail);

        // dekompresja
        MimeBodyPart     recoveredPart = SMIMEUtil.toMimeBodyPart(compressed.getContent());

        // wywietlenie zawartoci
        System.out.print("Zawarto: ");
        System.out.println(recoveredPart.getContent());
    }
}