package rozdzial8;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

import javax.security.auth.x500.X500PrivateCredential;

/**
 * Klasa narzdziowa do rozdziau 8.
 */
public class Utils extends rozdzial7.Utils
{
    public static String ROOT_ALIAS = "glowny";
    public static String INTERMEDIATE_ALIAS = "posredni";
    public static String END_ENTITY_ALIAS = "koncowy";
    
    /**
     * Wygenerowanie obiektu X500PrivateCredential dla podmiotu certyfikatu gwnego.
     */
    public static X500PrivateCredential createRootCredential()
        throws Exception
    {
        KeyPair         rootPair = generateRSAKeyPair();
        X509Certificate rootCert = generateRootCert(rootPair);
        
        return new X500PrivateCredential(rootCert, rootPair.getPrivate(), ROOT_ALIAS);
    }
    
    /**
     * Wygenerowanie obiektu X500PrivateCredential dla podmiotu certyfikatu poredniego.
     */
    public static X500PrivateCredential createIntermediateCredential(
        PrivateKey      caKey,
        X509Certificate caCert)
        throws Exception
    {
        KeyPair         interPair = generateRSAKeyPair();
        X509Certificate interCert = generateIntermediateCert(interPair.getPublic(), caKey, caCert);
        
        return new X500PrivateCredential(interCert, interPair.getPrivate(), INTERMEDIATE_ALIAS);
    }
    
    /**
     * Wygenerowanie obiektu X500PrivateCredential dla podmiotu certyfikatu kocowego.
     */
    public static X500PrivateCredential createEndEntityCredential(
        PrivateKey      caKey,
        X509Certificate caCert)
        throws Exception
    {
        KeyPair         endPair = generateRSAKeyPair();
        X509Certificate endCert = generateEndEntityCert(endPair.getPublic(), caKey, caCert);
        
        return new X500PrivateCredential(endCert, endPair.getPrivate(), END_ENTITY_ALIAS);
    }
}