package rozdzial8;

import java.security.KeyStore;

/**
 * Prosty przykad wykorzystania klasy KeyStore.Builder do stworzenia obiektu,
 * z ktrego mona pniej pobra klucz prywatny.
 */
public class JCEKSStoreBuilderExample
{
    public static void main(
        String[]    args)
        throws Exception
    {
        KeyStore store = JCEKSStoreEntryExample.createKeyStore();

        char[]   password = "hasloSkladu".toCharArray();

        // utworzenie obiektu KeyStore.Builder
        KeyStore.Builder builder = KeyStore.Builder.newInstance(store, new KeyStore.PasswordProtection(JCEKSStoreEntryExample.keyPassword));

        // pobranie zapisanego repozytorium kluczy i odtworzenie klucza
        store = builder.getKeyStore();

        KeyStore.ProtectionParameter param = builder.getProtectionParameter(Utils.END_ENTITY_ALIAS);

        KeyStore.Entry entry = store.getEntry(Utils.END_ENTITY_ALIAS, param);

        System.out.println("klasa odtworzonego obiektu: " + entry.getClass());
    }
}
