package rozdzial7;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.cert.CertStore;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.*;

/**
 * Przykad uycia klas X509CRLSelector i CertStore.
 */
public class CRLCertStoreExample
{
    public static void main(String[] args)
        throws Exception
    {
        // utworzenie kluczy i certyfikatu gwnego
        KeyPair              caPair = Utils.generateRSAKeyPair();
        X509Certificate      caCert = Utils.generateRootCert(caPair);
        BigInteger           revokedSerialNumber = BigInteger.valueOf(2);
        
        // utworzenie listy CRL uniewaniajcej certyfikat numer 2
        X509CRL                crl = X509CRLExample.createCRL(caCert, caPair.getPrivate(), revokedSerialNumber);

        // umieszczenie listy w repozytorium CertStore
        CollectionCertStoreParameters params = new CollectionCertStoreParameters(Collections.singleton(crl));
        CertStore                     store = CertStore.getInstance("Collection", params, "BC");
        X509CRLSelector               selector = new X509CRLSelector();
        
        selector.addIssuerName(caCert.getSubjectX500Principal().getEncoded());
        
        Iterator                      it = store.getCRLs(selector).iterator();
        
        while (it.hasNext())
        {
            crl = (X509CRL)it.next();
            
            // sprawdzenie listy
            crl.verify(caCert.getPublicKey(), "BC");
           
            // sprawdzenie, czy lista uniewania certyfikat numer 2
            X509CRLEntry entry = crl.getRevokedCertificate(revokedSerialNumber);
            System.out.println("Szczegy uniewanienia:");
            System.out.println("  Numer certyfikatu: " + entry.getSerialNumber());
            System.out.println("  Wystawca         : " + crl.getIssuerX500Principal());
        }
    }
}
