package rozdzial6;

import java.math.BigInteger;
import java.security.*;
import java.security.cert.X509Certificate;
import java.util.Date;

import javax.security.auth.x500.X500Principal;

import org.bouncycastle.x509.X509V1CertificateGenerator;


/**
 * Tworzenie podstawowego certyfikatu X.509 V1.
 */
public class X509V1CreateExample
{
    public static X509Certificate generateV1Certificate(KeyPair pair)
        throws InvalidKeyException, NoSuchProviderException, SignatureException
    {
        // generowanie certyfikatu
        X509V1CertificateGenerator  certGen = new X509V1CertificateGenerator();

        certGen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
        certGen.setIssuerDN(new X500Principal("CN=Certyfikat Testowy"));
        certGen.setNotBefore(new Date(System.currentTimeMillis() - 50000));
        certGen.setNotAfter(new Date(System.currentTimeMillis() + 50000));
        certGen.setSubjectDN(new X500Principal("CN=Certyfikat Testowy"));
        certGen.setPublicKey(pair.getPublic());
        certGen.setSignatureAlgorithm("SHA256WithRSAEncryption");

        return certGen.generateX509Certificate(pair.getPrivate(), "BC");
    }
    
    public static void main(
        String[]    args)
        throws Exception
    {
        // tworzenie kluczy
        KeyPair          pair = Utils.generateRSAKeyPair();
        
        // generowanie certyfikatu
        X509Certificate cert = generateV1Certificate(pair);

        // podstawowe sprawdzenie
        cert.checkValidity(new Date());

        cert.verify(cert.getPublicKey());
        
        System.out.println("wygenerowano poprawny certyfikat");
    }
}
