package rozdzial6;

import java.io.OutputStreamWriter;
import java.security.KeyPair;
import java.security.KeyPairGenerator;

import javax.security.auth.x500.X500Principal;

import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.openssl.PEMWriter;

/**
 * Generowanie podstawowego dania PKCS #10.
 */
public class PKCS10CertRequestExample
{
    public static PKCS10CertificationRequest generateRequest(
        KeyPair pair)
        throws Exception
    {
        return new PKCS10CertificationRequest(
                "SHA256withRSA",
                new X500Principal("CN=Zadany Certyfikat Testowy"),
                pair.getPublic(),
                null,
                pair.getPrivate());
    }
    
    public static void main(
        String[]    args)
        throws Exception
    {
        // utworzenie kluczy
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA", "BC");
        
        kpGen.initialize(1024, Utils.createFixedRandom());
        
        KeyPair          pair = kpGen.generateKeyPair();
        
        PKCS10CertificationRequest  request = generateRequest(pair);
        
        PEMWriter        pemWrt = new PEMWriter(new OutputStreamWriter(System.out));
        
        pemWrt.writeObject(request);
        
        pemWrt.close();
    }
}