package rozdzial6;

import java.security.cert.CertStore;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Iterator;

import javax.security.auth.x500.X500Principal;

/**
 * Przykad wykorzystania repozytorium certyfikatw CertStore i selektora CertSelector.
 */
public class CertStoreExample
{
    public static void main(String[] args)
        throws Exception
    {
        X509Certificate[]   chain = PKCS10CertCreateExample.buildChain();
        
        // utworzenie repozytorium
        CollectionCertStoreParameters params = new CollectionCertStoreParameters(Arrays.asList(chain));
        CertStore store = CertStore.getInstance("Collection", params, "BC");
        
        // utworzenie selektora
        X509CertSelector selector = new X509CertSelector();
        selector.setSubject(new X500Principal("CN=Zadany Certyfikat Testowy").getEncoded());

        // wypisanie podmiotw znalezionych certyfikatw
        Iterator certsIt = store.getCertificates(selector).iterator();
        while (certsIt.hasNext()) 
        {
            X509Certificate cert = (X509Certificate)certsIt.next();
            
            System.out.println(cert.getSubjectX500Principal());
        }
    }
}