package rozdzial5;

import java.security.*;

import javax.crypto.Cipher;

import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.util.ASN1Dump;

/**
 * Prosta klasa do badania struktury podpisu PKCS #1 V1.5.
 */
public class PKCS1SigEncodingExample
{
    public static void main(
        String[]    args)
        throws Exception
    {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", "BC");
        
        keyGen.initialize(512, new SecureRandom());
        
        KeyPair             keyPair = keyGen.generateKeyPair();
        Signature           signature = Signature.getInstance("SHA256withRSA", "BC");

        // tworzenie podpisu
        signature.initSign(keyPair.getPrivate());

        byte[] message = new byte[] { (byte)'a', (byte)'b', (byte)'c' };

        signature.update(message);

        byte[]  sigBytes = signature.sign();
        
        // odszyfrowanie podpisu
        Cipher cipher = Cipher.getInstance("RSA/None/PKCS1Padding", "BC");
        
        cipher.init(Cipher.DECRYPT_MODE, keyPair.getPublic());
        
        byte[]  decSig = cipher.doFinal(sigBytes);
        
        // przetworzenie podpisu
        ASN1InputStream aIn = new ASN1InputStream(decSig);
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        
        System.out.println(ASN1Dump.dumpAsString(seq));
        
        // wyliczenie skrtu odpowiednim algorytmem
        MessageDigest   hash = MessageDigest.getInstance("SHA-256", "BC");
        
        hash.update(message);

        ASN1OctetString sigHash = (ASN1OctetString)seq.getObjectAt(1);
        if (MessageDigest.isEqual(hash.digest(), sigHash.getOctets()))
        {
            System.out.println("weryfikacja skrtu zakoczona powodzeniem");
        }
        else
        {
            System.out.println("weryfikacja skrtu zakoczona niepowodzeniem");
        }
    }
}