package rozdzial4;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;

public class BasicPSSExample
{
    public static void main(
        String[]    args)
        throws Exception
    {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", "BC");
        
        keyGen.initialize(512, new SecureRandom());
        
        KeyPair             keyPair = keyGen.generateKeyPair();
        Signature           signature = Signature.getInstance("SHA1withRSAandMGF1", "BC");

        // generowanie podpisu
        signature.initSign(keyPair.getPrivate(), Utils.createFixedRandom());

        byte[] message = new byte[] { (byte)'a', (byte)'b', (byte)'c' };

        signature.update(message);

        byte[]  sigBytes = signature.sign();
        
        // sprawdzenie podpisu
        signature.initVerify(keyPair.getPublic());
        
        // ustawienie parametrw
        signature.setParameter(new PSSParameterSpec("SHA-1", "MGF1", MGF1ParameterSpec.SHA1, 20, 1));

        signature.update(message);

        if (signature.verify(sigBytes))
        {
            System.out.println("weryfikacja podpisu zakoczona powodzeniem.");
        }
        else
        {
            System.out.println("weryfikacja podpisu zakoczona niepowodzeniem.");
        }
    }
}