package rozdzial3;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;

import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

/**
 * Oglne metody narzdziowe dla przykadw z rozdziau 3.
 */
public class Utils
    extends rozdzial2.Utils
{
    /**
     * Tworzy klucz dla algorytmu AES.
     * 
     * @param bitLength dugo klucza w bitach
     * @param random rdo losowoci
     * @return klucz AES
     * @throws NoSuchAlgorithmException
     * @throws NoSuchProviderException
     */
    public static SecretKey createKeyForAES(
        int          bitLength,
        SecureRandom random)
        throws NoSuchAlgorithmException, NoSuchProviderException
    {
        KeyGenerator generator = KeyGenerator.getInstance("AES", "BC");
        
        generator.init(256, random);
        
        return generator.generateKey();
    }
    
    /**
     * Tworzy IV dla szyfrowania AES w trybie CTR.
     * <p>
     * IV skada si z 4-bajtowego numeru wiadomoci, 4 bajtw losowych danych
     * i 8-bajtowego licznika.
     * 
     * @param messageNumber numer wiadomoci
     * @param random rdo losowoci
     * @return inicjalizowany obiekt IvParameterSpec
     */
    public static IvParameterSpec createCtrIvForAES(
        int             messageNumber,
        SecureRandom    random)
    {
        byte[]          ivBytes = new byte[16];
        
        // losowa inicjalizacja
        
        random.nextBytes(ivBytes);
        
        // ustawienie bajtw numeru wiadomoci
        
        ivBytes[0] = (byte)(messageNumber >> 24);
        ivBytes[1] = (byte)(messageNumber >> 16);
        ivBytes[2] = (byte)(messageNumber >> 8);
        ivBytes[3] = (byte)(messageNumber >> 0);
        
        // ustawienie bajtw licznika na 1
        
        for (int i = 0; i != 7; i++)
        {
            ivBytes[8 + i] = 0;
        }
        
        ivBytes[15] = 1;
        
        return new IvParameterSpec(ivBytes);
    }
    
    /**
     * Konwertuje tablic bajtow 8-bitowych znakw na obiekt String.
     * 
     * @param bytes tablica zawierajca znaki
     * @param length liczba bajtw do przetworzenia
     * @return obiekt String odpowiadajcy znakom z tablicy
     */
    public static String toString(
        byte[] bytes,
        int    length)
    {
        char[] chars = new char[length];
        
        for (int i = 0; i != chars.length; i++)
        {
            chars[i] = (char)(bytes[i] & 0xff);
        }
        
        return new String(chars);
    }
    
    /**
     * Konwertuje tablic bajtow 8-bitowych znakw na obiekt String.
     * 
     * @param bytes tablica zawierajca znaki
     * @return obiekt String odpowiadajcy znakom z tablicy
     */
    public static String toString(
        byte[] bytes)
    {
        return toString(bytes, bytes.length);
    }
    
    /**
     * Konwertuje przekazany obiekt String na tablic bajtw biorc
     * pod uwag 8 mniej znaczcych bitw kadego znaku.
     * 
     * @param string napis do konwersji
     * @return tablica bajtw odpowiadajca przekazanemu cigowi
     */
    public static byte[] toByteArray(
        String string)
    {
        byte[] bytes = new byte[string.length()];
        char[]  chars = string.toCharArray();
        
        for (int i = 0; i != chars.length; i++)
        {
            bytes[i] = (byte)chars[i];
        }
        
        return bytes;
    }
}
