package rozdzial3;

import java.security.Key;
import java.security.SecureRandom;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;

/**
 * Modyfikacja wiadomoci szyfrowanej AES w trybie CTR.
 */
public class TamperedExample
{   
    public static void main(
        String[]    args)
        throws Exception
    {
        SecureRandom random = new SecureRandom();
        IvParameterSpec ivSpec = Utils.createCtrIvForAES(1, random);
        Key             key = Utils.createKeyForAES(256, random);
        Cipher          cipher = Cipher.getInstance("AES/CTR/NoPadding", "BC");
        String          input = "Przelew 0000100 na AC 1234-5678";

        System.out.println("dane wejciowe: " + input);
        
        // etap szyfrowania
        
        cipher.init(Cipher.ENCRYPT_MODE, key, ivSpec);
        
        byte[] cipherText = cipher.doFinal(Utils.toByteArray(input));

        // etap modyfikacji
        
        cipherText[8] ^= '0' ^ '9';
        
        // etap deszyfrowania
        
        cipher.init(Cipher.DECRYPT_MODE, key, ivSpec);
        
        byte[] plainText = cipher.doFinal(cipherText);
        
        System.out.println("dane odszyfrowane: " + Utils.toString(plainText));
    }
}
