package rozdzial2;

/**
 * Oglna klasa narzdziowa dla przykadw z rozdziau drugiego.
 */
public class Utils
{
    private static String  digits = "0123456789abcdef";
    
    /**
     * Zwraca length bajtw z przekazanej tablicy bajtw jako cig szesnastkowy.
     * 
     * @param data tablica bajtw do konwersji.
     * @param length liczba bajtw do konwersji w bloku danych.
     * @return szesnastkowy zapis length bajtw danych.
     */
    public static String toHex(byte[] data, int length)
    {
        StringBuffer buf = new StringBuffer();
        
        for (int i = 0; i != length; i++)
        {
            int   v = data[i] & 0xff;
            
            buf.append(digits.charAt(v >> 4));
            buf.append(digits.charAt(v & 0xf));
        }
        
        return buf.toString();
    }
    
    /**
     * Zwraca przekazan tablic bajtw jako cig szesnastkowy.
     * 
     * @param data tablica bajtw do konwersji.
     * @return szesnastkowy zapis bajtw danych.
     */
    public static String toHex(byte[] data)
    {
        return toHex(data, data.length);
    }
}
