package rozdzial2;

import java.security.Key;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;

public class SimpleCipherWrapExample
{
    public static void main(
        String[]    args)
        throws Exception
    {
        // utworzenie klucza do opakowania
        
        KeyGenerator generator = KeyGenerator.getInstance("AES", "BC");
        generator.init(128);

        Key keyToBeWrapped = generator.generateKey();

        System.out.println("klucz wejciowy : " + Utils.toHex(keyToBeWrapped.getEncoded()));
        
        // utworzenie klucza opakowujcego i samo opakowanie
        
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding", "BC");
        
        KeyGenerator keyGen = KeyGenerator.getInstance("AES", "BC");
        keyGen.init(256);
        
        Key wrapKey = keyGen.generateKey();
        
        cipher.init(Cipher.ENCRYPT_MODE, wrapKey);
        
        byte[] wrappedKey = cipher.doFinal(keyToBeWrapped.getEncoded());

        System.out.println("klucz opakowany : " + Utils.toHex(wrappedKey));
        
        // odpakowanie klucza
        
        cipher.init(Cipher.DECRYPT_MODE, wrapKey);
        
        Key key = new SecretKeySpec(cipher.doFinal(wrappedKey), "AES");

        System.out.println("klucz odpakowany: " + Utils.toHex(key.getEncoded()));
    }
}
