package rozdzial10;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.Principal;

import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;

/**
 * Prosty serwer SSL z uwierzytelnianiem klienta i sprawdzaniem jego identyfikatora.
 */
public class SSLServerWithClientAuthIdExample
    extends SSLServerExample
{
    /**
     * Sprawdza, czy przekazany identyfikator faktycznie dotyczy zgaszajcego si klienta.
     */
    static boolean isEndEntity(
        SSLSession session) 
        throws SSLPeerUnverifiedException
    {
        Principal id = session.getPeerPrincipal();
        if (id instanceof X500Principal)
        {
            X500Principal x500 = (X500Principal)id;
            
            return x500.getName().equals("CN=Testowy Certyfikat Koncowy");
        }
        
        return false;
    }
    
    /**
     * Tworzy kontekst SSL z osobnymi repozytoriami kluczy i certyfikatw zaufanych.
     */
    static SSLContext createSSLContext() 
        throws Exception
    {
        // przygotowanie menedera kluczy dla wasnych danych identyfikacyjnych
      KeyManagerFactory mgrFact = KeyManagerFactory.getInstance("SunX509");
      KeyStore serverStore = KeyStore.getInstance("JKS");

      serverStore.load(new FileInputStream("serwer.jks"), Utils.SERVER_PASSWORD);

      mgrFact.init(serverStore, Utils.SERVER_PASSWORD);
      
      // przygotowanie menedera zaufanych certyfikatw tak, by rozpoznawa serwer
      TrustManagerFactory trustFact = TrustManagerFactory.getInstance("SunX509");
      KeyStore            trustStore = KeyStore.getInstance("JKS");
      
      trustStore.load(new FileInputStream("skladZaufany.jks"), Utils.TRUST_STORE_PASSWORD);
      
      trustFact.init(trustStore);
      
      // utworzenie kontekstu i przygotowanie obiektu fabrykujcego gniazda
      SSLContext sslContext = SSLContext.getInstance("TLS");

      sslContext.init(mgrFact.getKeyManagers(), trustFact.getTrustManagers(), null);

      return sslContext;
    }
    
    public static void main(
        String[] args)
        throws Exception
    {    
      // utworzenie kontekstu i przygotowanie obiektu fabrykujcego gniazda
      SSLContext sslContext = createSSLContext();

      // utworzenie gniazda serwerowego
        SSLServerSocketFactory fact = sslContext.getServerSocketFactory();
        SSLServerSocket        sSock = (SSLServerSocket)fact.createServerSocket(Utils.PORT_NO);
    
        sSock.setNeedClientAuth(true);
        
        SSLSocket sslSock = (SSLSocket)sSock.accept();
        
        sslSock.startHandshake();
        
        // przetwarzanie tylko w przypadku prawidowej nazwy klienta
        if (isEndEntity(sslSock.getSession()))
        {
            doProtocol(sslSock);
        }
    }
}