package rozdzial10;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;

/**
 * Prosty serwer SSL obsugujcy protok z wykrzyknikiem.
 */
public class SSLServerExample 
{
    /**
     * Obsuga protokou z wykrzyknikiem - strona serwera.
     */
    static void doProtocol(
        Socket sSock)
        throws IOException
    {
        System.out.println("sesja rozpoczta.");
        
        InputStream in = sSock.getInputStream();
        OutputStream out = sSock.getOutputStream();

        out.write(Utils.toByteArray("Hello "));
        
        int ch = 0;
        while ((ch = in.read()) != '!')
        {
            out.write(ch);
        }
        
        out.write('!');

        sSock.close();
        
        System.out.println("sesja zakoczona.");
    }
    
    public static void main(
        String[] args)
        throws Exception
    {
        SSLServerSocketFactory fact = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        SSLServerSocket        sSock = (SSLServerSocket)fact.createServerSocket(Utils.PORT_NO);
        
        SSLSocket sslSock = (SSLSocket)sSock.accept();
        
        doProtocol(sslSock);
    }
}