package rozdzial10;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

/**
 * Prosty klient SSL obsugujcy protok z wykrzyknikiem.
 */
public class SSLClientExample
{
    /**
     * Obsuenie protokou z wykrzyknikiem - strona klienta.
     */
    static void doProtocol(
        Socket cSock)
        throws IOException
    {
        OutputStream     out = cSock.getOutputStream();
        InputStream      in = cSock.getInputStream();
        
        out.write(Utils.toByteArray("World"));
        out.write('!');
        
        int ch = 0;
        while ((ch = in.read()) != '!')
        {
            System.out.print((char)ch);
        }
        
        System.out.println((char)ch);
    }
    
    public static void main(
        String[] args)
        throws Exception
    {
        SSLSocketFactory fact = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket        cSock = (SSLSocket)fact.createSocket(Utils.HOST, Utils.PORT_NO);
        
        doProtocol(cSock);
    }
}
