package rozdzial9;

import java.security.KeyStore;
import java.security.cert.*;
import java.util.*;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.security.auth.x500.X500PrivateCredential;


/**
 * Klasa narzdziowa do rozdziau 9.
 */
public class Utils extends rozdzial8.Utils
{
    public static char[] KEY_PASSWD = "hasloKlucza".toCharArray();
    
    /**
     * Tworzy repozytorium kluczy zawierajcy prywatne dane identyfikacyjne
     * z acuchem certyfikatw i punktem zaufania.
     */
    public static KeyStore createCredentials()
        throws Exception
    {
        KeyStore store = KeyStore.getInstance("JKS");

        store.load(null, null);
        
        X500PrivateCredential    rootCredential = Utils.createRootCredential();
        X500PrivateCredential    interCredential = Utils.createIntermediateCredential(rootCredential.getPrivateKey(), rootCredential.getCertificate());
        X500PrivateCredential    endCredential = Utils.createEndEntityCredential(interCredential.getPrivateKey(), interCredential.getCertificate());
        
        store.setCertificateEntry(rootCredential.getAlias(), rootCredential.getCertificate());
        store.setKeyEntry(endCredential.getAlias(), endCredential.getPrivateKey(), KEY_PASSWD, 
                new Certificate[] { endCredential.getCertificate(), interCredential.getCertificate(), rootCredential.getCertificate() });

        return store;
    }
    
    /**
     * Buduje ciek zaczynajc si od podanego punktu zaufania, uwzgldniajc
     * przekazane ograniczenia certyfikatu kocowego i repozytorium certyfikatw.
     * <p>
     * Uwaga: cieka jest budowana z wyczonym sprawdzaniem uniewanienia.
     */
    public static PKIXCertPathBuilderResult buildPath(
        X509Certificate  rootCert,
        X509CertSelector endConstraints,
        CertStore        certsAndCRLs)
        throws Exception
    {
        CertPathBuilder       builder = CertPathBuilder.getInstance("PKIX", "BC");
        PKIXBuilderParameters buildParams = new PKIXBuilderParameters(Collections.singleton(new TrustAnchor(rootCert, null)), endConstraints);
        
        buildParams.addCertStore(certsAndCRLs);
        buildParams.setRevocationEnabled(false);
        
        return (PKIXCertPathBuilderResult)builder.build(buildParams);
    }
    
    /**
     * Tworzy wiadomo MIME na podstawie przekazanej treci.
     */
    public static MimeMessage createMimeMessage(
        String subject, 
        Object content, 
        String contentType) 
        throws MessagingException
    {
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance(props, null);

        Address fromUser = new InternetAddress("\"Karol E. Kolczatka\"<karol@bouncycastle.org>");
        Address toUser = new InternetAddress("przyklad@bouncycastle.org");

        MimeMessage message = new MimeMessage(session);
        
        message.setFrom(fromUser);
        message.setRecipient(Message.RecipientType.TO, toUser);
        message.setSubject(subject);
        message.setContent(content, contentType);
        message.saveChanges();
        
        return message;
    }
}