package rozdzial9;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.*;
import java.util.Arrays;

import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.asn1.smime.SMIMEEncryptionKeyPreferenceAttribute;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.mail.smime.SMIMEUtil;

/**
 * Prosty przykad tworzenia i przetwarzania podpisanej wiadomoci e-mail.
 */
public class SignedMailExample
    extends SignedDataProcessor
{
    public static MimeMultipart createMultipartWithSignature(
        PrivateKey      key,
        X509Certificate cert,
        CertStore       certsAndCRLs,
        MimeBodyPart    dataPart) 
        throws Exception
    {
        // utworzenie kilku moliwoci S/MIME na wypadek, gdyby kto chcia odpowiedzie
        ASN1EncodableVector         signedAttrs = new ASN1EncodableVector();
        SMIMECapabilityVector       caps = new SMIMECapabilityVector();

        caps.addCapability(SMIMECapability.aES256_CBC);
        caps.addCapability(SMIMECapability.dES_EDE3_CBC);
        caps.addCapability(SMIMECapability.rC2_CBC, 128);

        signedAttrs.add(new SMIMECapabilitiesAttribute(caps));
        signedAttrs.add(new SMIMEEncryptionKeyPreferenceAttribute(SMIMEUtil.createIssuerAndSerialNumberFor(cert)));

        // przygotowanie generatora
        SMIMESignedGenerator gen = new SMIMESignedGenerator();

        gen.addSigner(key, cert, SMIMESignedGenerator.DIGEST_SHA256, new AttributeTable(signedAttrs), null);

        gen.addCertificatesAndCRLs(certsAndCRLs);

        // utworzenie podpisanej wiadomoci
        return gen.generate(dataPart, "BC");
    }
    
    public static void main(
        String args[])
        throws Exception
    {
        KeyStore        credentials = Utils.createCredentials();
        PrivateKey      key = (PrivateKey)credentials.getKey(Utils.END_ENTITY_ALIAS, Utils.KEY_PASSWD);
        Certificate[]   chain = credentials.getCertificateChain(Utils.END_ENTITY_ALIAS);
        CertStore       certsAndCRLs = CertStore.getInstance("Collection",
                            new CollectionCertStoreParameters(Arrays.asList(chain)), "BC");
        X509Certificate cert = (X509Certificate)chain[0];

        // utworzenie wiadomoci, ktra ma by podpisana
        MimeBodyPart    dataPart = new MimeBodyPart();

        dataPart.setText("Hello world!");
        
        // utworzenie podpisanej wiadomoci
        MimeMultipart multiPart = createMultipartWithSignature(key, cert, certsAndCRLs, dataPart);

        // utworzenie wiadomoci e-mail
        MimeMessage mail = Utils.createMimeMessage("przykladowa podpisana wiadomosc", multiPart, multiPart.getContentType());

        // pobranie zawartoci wiadomoci e-mail
        if (mail.isMimeType("multipart/signed"))
        {
            SMIMESigned             signed = new SMIMESigned(
                                            (MimeMultipart)mail.getContent());
            
            // weryfikacja
            X509Certificate rootCert = (X509Certificate)credentials.getCertificate(Utils.ROOT_ALIAS);
            
            if (isValid(signed, rootCert))
            {
                System.out.println("weryfikacja zakoczona powodzeniem");
            }
            else
            {
                System.out.println("weryfikacja nie powioda si");
            }
            
            // wywietlenie zawartoci
            MimeBodyPart            content = signed.getContent();

            System.out.print("Zawarto: ");
            System.out.println(content.getContent());
        }
        else
        {
            System.out.println("nieprawidowa zawarto wiadomoci");
        }
    }
}
