package rozdzial9;

import java.security.cert.*;
import java.util.Iterator;

import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;

/**
 * Klasa bazowa dla przykadw z podpisanymi danymi.
 */
public class SignedDataProcessor
{
    /**
     * Zwraca tablic typu boolean odpowiadajc cigowi bitw dla rozszerzenia 
     * keyUsage z ustawionym bitem digitalSignature.
     */
    static boolean[] getKeyUsageForSignature()
    {
        boolean[] val = new boolean[9];

        val[0] = true;

        return val;
    }
    
    /**
     * Przyjmuje wiadomo CMS z podpisanymi danymi oraz punkt zaufania i na
     * ich podstawie ustala, czy podpis wiadomoci daje si sprawdzi certyfikatem
     * uytkownika kocowego uznawanym przez punkt zaufania rootCert.
     */
    public static boolean isValid(
        CMSSignedData   signedData,
        X509Certificate rootCert)
        throws Exception
    {
        CertStore certsAndCRLs = signedData.getCertificatesAndCRLs("Collection", "BC");
        SignerInformationStore  signers = signedData.getSignerInfos();
        Iterator                it = signers.getSigners().iterator();

        if (it.hasNext())
        {
            SignerInformation         signer = (SignerInformation)it.next();
            X509CertSelector          signerConstraints = signer.getSID();
            
            signerConstraints.setKeyUsage(getKeyUsageForSignature());
            
            PKIXCertPathBuilderResult result = Utils.buildPath(rootCert, signer.getSID(), certsAndCRLs);

            return signer.verify(result.getPublicKey(), "BC");
        }
        
        return false;
    }
}
