package rozdzial9;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;

import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;

/**
 * Pokazuje tworzenie i przetwarzanie opakowanej wiadomoci z odbiorc korzystajcym z klucza publicznego.
 */
public class KeyTransEnvelopedDataExample
{
    public static void main(String[] args)
        throws Exception
    {
        KeyStore        credentials = Utils.createCredentials();
        PrivateKey      key = (PrivateKey)credentials.getKey(Utils.END_ENTITY_ALIAS, Utils.KEY_PASSWD);
        Certificate[]   chain = credentials.getCertificateChain(Utils.END_ENTITY_ALIAS);
        X509Certificate cert = (X509Certificate)chain[0];

        // przygotowanie generatora
        CMSEnvelopedDataGenerator gen = new CMSEnvelopedDataGenerator();
        
        gen.addKeyTransRecipient(cert);
        
        // utworzenie obiektu opakowanych danych
        CMSProcessable   data = new CMSProcessableByteArray("Hello World!".getBytes());

        CMSEnvelopedData enveloped = gen.generate(
                                data,
                                CMSEnvelopedDataGenerator.AES128_CBC, "BC");

        // odtworzenie
        enveloped = new CMSEnvelopedData(enveloped.getEncoded());
        
        // wyszukanie identyfikatora odbiorcy
        RecipientId     recId = new RecipientId();

        recId.setSerialNumber(cert.getSerialNumber());
        recId.setIssuer(cert.getIssuerX500Principal().getEncoded());

        RecipientInformationStore   recipients = enveloped.getRecipientInfos();
        RecipientInformation        recipient = recipients.get(recId);
        
        if (recipient != null)
        {
            // odszyfrowanie danych
            byte[] recData = recipient.getContent(key, "BC");

            // porwnanie danych odtworzonych z oryginalnymi
            if (Arrays.equals((byte[])data.getContent(), recData))
            {
                System.out.println("dane odtworzone pomylnie");
            }
            else
            {
                System.out.println("odtwarzanie danych nie powiodo si");
            }
        }
        else
        {
            System.out.println("nie znaleziono pasujcego odbiorcy");
        }
    }
}