package rozdzial9;

import java.util.Arrays;

import javax.crypto.*;

import org.bouncycastle.cms.*;

/**
 * Pokazuje tworzenie i przetwarzanie koperty cyfrowej z odbiorc korzystajcym z klucza szyfrowanego 
 * kluczem symetrycznym.
 */
public class KEKEnvelopedDataExample
{
    public static void main(String[] args)
        throws Exception
    {
        KeyGenerator    keyGen = KeyGenerator.getInstance("DESEDE", "BC");
        SecretKey       key  = keyGen.generateKey();
        
        // przygotowanie generatora
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();

        byte[]  kekID = new byte[] { 1, 2, 3, 4, 5 };

        edGen.addKEKRecipient(key, kekID);
        
        // utworzenie obiektu koperty cyfrowej
        CMSProcessable  data = new CMSProcessableByteArray("Hello World!".getBytes());

        CMSEnvelopedData enveloped = edGen.generate(
                                data,
                                CMSEnvelopedDataGenerator.AES128_CBC, "BC");
        // odtworzenie
        enveloped = new CMSEnvelopedData(enveloped.getEncoded());

        // wyszukanie identyfikatora odbiorcy
        RecipientId     recId = new RecipientId();

        recId.setKeyIdentifier(kekID);

        RecipientInformationStore   recipients = enveloped.getRecipientInfos();
        RecipientInformation        recipient = recipients.get(recId);
        
        if (recipient != null)
        {
            // odszyfrowanie danych
            byte[] recData = recipient.getContent(key, "BC");

            // porwnanie odtworzonych danych z oryginalnymi
            if (Arrays.equals((byte[])data.getContent(), recData))
            {
                System.out.println("dane odtworzone pomylnie");
            }
            else
            {
                System.out.println("odtwarzanie danych nie powiodo si");
            }
        }
        else
        {
            System.out.println("nie znaleziono pasujcego odbiorcy");
        }
    }
}