package rozdzial9;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;

import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import org.bouncycastle.mail.smime.SMIMEUtil;

/**
 * Prosty przykad tworzenia i przetwarzania koperty cyfrowej opakowanej w wiadomo e-mail.
 */
public class EnvelopedMailExample
{
    public static void main(
        String args[])
        throws Exception
    {
        KeyStore        credentials = Utils.createCredentials();
        PrivateKey      key = (PrivateKey)credentials.getKey(Utils.END_ENTITY_ALIAS, Utils.KEY_PASSWD);
        Certificate[]   chain = credentials.getCertificateChain(Utils.END_ENTITY_ALIAS);
        X509Certificate cert = (X509Certificate)chain[0];

        // utworzenie wiadomoci do zaszyfrowania
        MimeBodyPart    dataPart = new MimeBodyPart();

        dataPart.setText("Hello world!");
        
        // przygotowanie generatora
        SMIMEEnvelopedGenerator  gen = new SMIMEEnvelopedGenerator();
          
        gen.addKeyTransRecipient(cert);

        // generowanie koperty cyfrowej
        MimeBodyPart envPart = gen.generate(dataPart, SMIMEEnvelopedGenerator.AES256_CBC, "BC");

        // utworzenie wiadomoci e-mail
        MimeMessage mail = Utils.createMimeMessage("przykladowa wiadomosc kopertowa", envPart.getContent(), envPart.getContentType());

        // odworzenie obiektu koperty z wiadomoci e-mail
        SMIMEEnveloped  enveloped = new SMIMEEnveloped(mail);

        // odnalezienie identyfikatora odbiorcy
        RecipientId     recId = new RecipientId();

        recId.setSerialNumber(cert.getSerialNumber());
        recId.setIssuer(cert.getIssuerX500Principal().getEncoded());

        RecipientInformationStore   recipients = enveloped.getRecipientInfos();
        RecipientInformation        recipient = recipients.get(recId);

        if (recipient != null)
        {
            // deszyfrowanie
            MimeBodyPart     recoveredPart = SMIMEUtil.toMimeBodyPart(recipient.getContent(key, "BC"));

            // wywietlenie zawartoci
            System.out.print("Zawarto: ");
            System.out.println(recoveredPart.getContent());
        }
        else
        {
            System.out.println("nie znaleziono pasujcego odbiorcy");
        }
    }
}