package rozdzial9;

import java.util.Arrays;

import org.bouncycastle.cms.CMSCompressedData;
import org.bouncycastle.cms.CMSCompressedDataGenerator;
import org.bouncycastle.cms.CMSProcessableByteArray;

/**
 * Prosty przykad uycia typu danych skompresowanych w CMS.
 */
public class CompressedDataExample
{
    public static void main(String args[])
        throws Exception
    {
        // przegotowanie generatora
        CMSCompressedDataGenerator gen = new CMSCompressedDataGenerator();

        // kompresja danych
        CMSProcessableByteArray  data = new CMSProcessableByteArray(
                                                    "Hello world!".getBytes());
        
        CMSCompressedData compressed = gen.generate(data,
                                        CMSCompressedDataGenerator.ZLIB);
        
        // odtworzenie i dekompresja danych
        compressed = new CMSCompressedData(compressed.getEncoded());
        
        byte[] recData = compressed.getContent();

        // porwnanie rozpakowanych danych z danymi wejciowymi
        if (Arrays.equals((byte[])data.getContent(), recData))
        {
            System.out.println("dane odtworzone pomylnie");
        }
        else
        {
            System.out.println("odtworzenie danych nie powiodo si");
        }
    }
}
