package rozdzial9;

import java.io.*;

import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;

/**
 * Wersja interfejsu CMSProcessable do pracy z obiektami klasy File.
 */
public class CMSProcessableFile
    implements CMSProcessable
{
    private File file;
    private static final int BUF_SIZE = 4096;
    
    /**
     * Konstruktor bazowy.
     * 
     * @param file obiekt klasy File odpowiadajcy przetwarzanemu plikowi
     */
    public CMSProcessableFile(
        File file)
    {
        this.file = file;
    }
    
    /**
     * Wypisuje zawarto pliku do przekazanego strumienia OutputStream.
     * 
     * @param out strumie OutputStream przekazany przez API CMS
     */
    public void write(
        OutputStream out)
        throws IOException, CMSException
    {
        FileInputStream fIn = new FileInputStream(file);
        byte[]          buf = new byte[BUF_SIZE];
        
        int count = 0;
        while ((count = fIn.read(buf)) > 0)
        {
            out.write(buf, 0, count);
        }
        
        fIn.close();
    }

    /**
     * Zwraca obiekt klasy File przekazany w konstruktorze.
     */
    public Object getContent()
    {
        return file;
    }
}
