package rozdzial8;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Enumeration;

import javax.security.auth.x500.X500PrivateCredential;

/**
 * Przykad prostego wykorzystania obiektu KeyStore.
 */
public class JKSStoreExample
{
    public static char[] keyPassword = "hasloKlucza".toCharArray();
    
    public static KeyStore createKeyStore()
        throws Exception
    {
        KeyStore store = KeyStore.getInstance("JKS");

        // inicjalizacja
        store.load(null, null);
        
        X500PrivateCredential    rootCredential = Utils.createRootCredential();
        X500PrivateCredential    interCredential = Utils.createIntermediateCredential(rootCredential.getPrivateKey(), rootCredential.getCertificate());
        X500PrivateCredential    endCredential = Utils.createEndEntityCredential(interCredential.getPrivateKey(), interCredential.getCertificate());

        Certificate[]            chain = new Certificate[3];
        
        chain[0] = endCredential.getCertificate();
        chain[1] = interCredential.getCertificate();
        chain[2] = rootCredential.getCertificate();
        
        // zapisanie wpisw
        store.setCertificateEntry(rootCredential.getAlias(), rootCredential.getCertificate());
        store.setKeyEntry(endCredential.getAlias(), endCredential.getPrivateKey(), keyPassword, chain);

        return store;
    }
    
    public static void main(
        String[]    args)
        throws Exception
    {
        KeyStore store = createKeyStore();
        char[]   password = "hasloSkladu".toCharArray();
        
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        
        // zapisanie repozytorium
        store.store(bOut, password);

        // zaadowanie repozytorium od zera
        store = KeyStore.getInstance("JKS");
        
        store.load(new ByteArrayInputStream(bOut.toByteArray()), null);

        Enumeration en = store.aliases();
        while (en.hasMoreElements())
        {
            String alias = (String)en.nextElement();
            System.out.println("znaleziono " + alias + ", czy to certyfikat? " + store.isCertificateEntry(alias));
        }
    }
}
