package rozdzial8;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.Enumeration;

import javax.crypto.SecretKey;
import javax.security.auth.x500.X500PrivateCredential;

/**
 * Przykad wykorzystania repozytorium kluczy typu JCEKS z obiektami klas KeyStore.Entry
 * i KeyStore.ProtectionParameter.
 */
public class JCEKSStoreEntryExample
{
    public static char[]   keyPassword = "hasloKoncowe".toCharArray();
    public static char[]   secretKeyPassword = "tajneHaslo".toCharArray();
    
    public static KeyStore createKeyStore()
        throws Exception
    {
        KeyStore store = KeyStore.getInstance("JCEKS");

        // inicjalizacja
        store.load(null, null);
        
        X500PrivateCredential    rootCredential = Utils.createRootCredential();
        X500PrivateCredential    interCredential = Utils.createIntermediateCredential(rootCredential.getPrivateKey(), rootCredential.getCertificate());
        X500PrivateCredential    endCredential = Utils.createEndEntityCredential(interCredential.getPrivateKey(), interCredential.getCertificate());

        Certificate[]            chain = new Certificate[3];
        
        chain[0] = endCredential.getCertificate();
        chain[1] = interCredential.getCertificate();
        chain[2] = rootCredential.getCertificate();
        
        SecretKey                 secret = Utils.createKeyForAES(256, new SecureRandom());
        
        // dodanie wpisw
        store.setEntry(rootCredential.getAlias(), new KeyStore.TrustedCertificateEntry(rootCredential.getCertificate()), null);
        store.setEntry(endCredential.getAlias(), new KeyStore.PrivateKeyEntry(endCredential.getPrivateKey(), chain), new KeyStore.PasswordProtection(keyPassword));
        store.setEntry("tajny", new KeyStore.SecretKeyEntry(secret), new KeyStore.PasswordProtection(secretKeyPassword));

        return store;
    }
    
    public static void main(
        String[]    args)
        throws Exception
    {
        KeyStore store = createKeyStore();
        char[]   password = "hasloSkladu".toCharArray();
        
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        
        // zapisanie repozytorium
        store.store(bOut, password);
        
        // zaadowanie repozytorium od zera
        store = KeyStore.getInstance("JCEKS");
        
        store.load(new ByteArrayInputStream(bOut.toByteArray()), password);

        Enumeration en = store.aliases();
        while (en.hasMoreElements())
        {
            String alias = (String)en.nextElement();
            System.out.println("znaleziono " + alias + ", czy to certyfikat? " + store.isCertificateEntry(alias) + ", czy to wpis klucza tajnego? " + store.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class));
        }
    }
}
