package rozdzial7;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Vector;

import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.ocsp.CertificateID;
import org.bouncycastle.ocsp.OCSPException;
import org.bouncycastle.ocsp.OCSPReq;
import org.bouncycastle.ocsp.OCSPReqGenerator;
import org.bouncycastle.ocsp.Req;

/**
 * Przykad generowania niepodpisanego zapytania OCSP.
 */
public class OCSPClientExample
{
    public static OCSPReq generateOCSPRequest(X509Certificate issuerCert, BigInteger serialNumber) 
        throws OCSPException
    {
        // wygenerowanie identyfikatora dla certyfikatu stanowicego przedmiot zapytania
        CertificateID   id = new CertificateID(CertificateID.HASH_SHA1, issuerCert, serialNumber);

        // wygenerowanie podstawowego zapytania z wartoci jednorazow
        OCSPReqGenerator    gen = new OCSPReqGenerator();
        
        gen.addRequest(id);
        
        // utworzenie wartoci rozszerzenia nonce
        BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
        Vector     oids = new Vector();
        Vector     values = new Vector();
        
        oids.add(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        values.add(new X509Extension(false, new DEROctetString(nonce.toByteArray())));
        
        gen.setRequestExtensions(new X509Extensions(oids, values));

        return gen.generate();
    }

    public static void main(
        String[] args)
        throws Exception
    {
        // utworzenie certyfikatw i list CRL
        KeyPair         rootPair = Utils.generateRSAKeyPair();
        KeyPair         interPair = Utils.generateRSAKeyPair();
        
        X509Certificate rootCert = Utils.generateRootCert(rootPair);
        X509Certificate interCert = Utils.generateIntermediateCert(interPair.getPublic(), rootPair.getPrivate(), rootCert);

        OCSPReq request = generateOCSPRequest(rootCert, interCert.getSerialNumber());

        Req[]   requests = request.getRequestList();
        
        for (int i = 0; i != requests.length; i++)
        {
            CertificateID certID = requests[i].getCertID();
            
            System.out.println("Zapytanie OCSP dotyczce certyfikatu numer " + certID.getSerialNumber());
        }
    }
}
