package rozdzial7;
 
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.cert.*;
import java.util.*;

/**
 * Prosty przykad walidacji cieki certyfikatw z wykorzystaniem klasy PKIXCertPathChecker.
 */
public class CertPathValidatorWithCheckerExample
{
    public static void main(
        String[] args)
        throws Exception
    {
        // utworzenie certyfikatw i list CRL
        KeyPair         rootPair = Utils.generateRSAKeyPair();
        KeyPair         interPair = Utils.generateRSAKeyPair();
        KeyPair         endPair = Utils.generateRSAKeyPair();
        
        X509Certificate rootCert = Utils.generateRootCert(rootPair);
        X509Certificate interCert = Utils.generateIntermediateCert(interPair.getPublic(), rootPair.getPrivate(), rootCert);
        X509Certificate endCert = Utils.generateEndEntityCert(endPair.getPublic(), interPair.getPrivate(), interCert);
        
        BigInteger      revokedSerialNumber = BigInteger.valueOf(2);
        
        // utworzenie repozytorium CertStore na potrzeby walidacji
        List list = new ArrayList();
        
        list.add(rootCert);
        list.add(interCert);
        list.add(endCert);
        
        CollectionCertStoreParameters params = new CollectionCertStoreParameters( list );
        CertStore                     store = CertStore.getInstance("Collection", params, "BC");

        // utworzenie cieki certyfikatw
        CertificateFactory fact = CertificateFactory.getInstance("X.509", "BC");
        List               certChain = new ArrayList();

        certChain.add(endCert);
        certChain.add(interCert);

        CertPath certPath = fact.generateCertPath(certChain);
        Set      trust = Collections.singleton(new TrustAnchor(rootCert, null));

        // walidacja
        CertPathValidator validator = CertPathValidator.getInstance("PKIX", "BC");
        PKIXParameters    param = new PKIXParameters(trust);
        
        param.addCertPathChecker(new PathChecker(rootPair, rootCert, revokedSerialNumber));
        param.setRevocationEnabled(false);
        param.addCertStore(store);
        param.setDate(new Date());
        
        try
        {
            CertPathValidatorResult result = validator.validate(certPath, param);

            System.out.println("walidacja cieki certyfikatw zakoczona powodzeniem");
        }
        catch (CertPathValidatorException e)
        {
            System.out.println("bd walidacji przy certyfikacie numer " + e.getIndex() + ", szczegy bdu: " + e.getMessage());
        }
    }
}

