package rozdzial7;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;

/**
 * Pobieranie listy CRL za pomoc obiektu CertificateFactory.
 */
public class CRLCertFactoryExample
{
    public static void main(String[] args)
        throws Exception
    {
        // utworzenie kluczy i certyfikatu gwnego
        KeyPair              caPair = Utils.generateRSAKeyPair();
        X509Certificate      caCert = Utils.generateRootCert(caPair);
        BigInteger           revokedSerialNumber = BigInteger.valueOf(2);
        
        // utworzenie listy CRL uniewaniajcej certyfikat numer 2
        X509CRL                crl = X509CRLExample.createCRL(caCert, caPair.getPrivate(), revokedSerialNumber);
        
        // zakodowanie i odtworzenie listy
        ByteArrayInputStream bIn = new ByteArrayInputStream(crl.getEncoded());
        CertificateFactory   fact = CertificateFactory.getInstance("X.509", "BC");
        
        crl = (X509CRL)fact.generateCRL(bIn);
        
        // sprawdzenie listy
        crl.verify(caCert.getPublicKey(), "BC");
        
        // sprawdzenie, czy lista uniewania certyfikat numer 2
        X509CRLEntry entry = crl.getRevokedCertificate(revokedSerialNumber);
        System.out.println("Szczegy uniewanienia:");
        System.out.println("  Numer certyfikatu: " + entry.getSerialNumber());
        System.out.println("  Wystawca         : " + crl.getIssuerX500Principal());
    }
}
