package rozdzial6;

import java.io.*;
import java.security.*;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

import org.bouncycastle.openssl.PEMWriter;

/**
 * Prosty przykad wykorzystania klasy CertificateFactory.
 */
public class PEMCertificateFactoryExample
{
    public static void main(String[] args)
        throws Exception
    {
        // utworzenie kluczy
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA", "BC");
        
        kpGen.initialize(1024, new SecureRandom());
        
        KeyPair          pair = kpGen.generateKeyPair();
        
        // utworzenie strumienia wejciowego
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        
        PEMWriter             pemWrt = new PEMWriter(new OutputStreamWriter(bOut));
        
        pemWrt.writeObject(X509V1CreateExample.generateV1Certificate(pair));
        
        pemWrt.close();
        
        bOut.close();
        
        System.out.println(Utils.toString(bOut.toByteArray()));
        
        InputStream in = new ByteArrayInputStream(bOut.toByteArray());
        
        // utworzenie obiektu fabrykujcego certyfikaty
        CertificateFactory fact = CertificateFactory.getInstance("X.509","BC");
        
        // wczytanie certyfikatu
        X509Certificate    x509Cert = (X509Certificate)fact.generateCertificate(in);
        
        System.out.println("wystawca: " + x509Cert.getIssuerX500Principal());
    }
}
