package rozdzial6;

import java.io.*;
import java.security.*;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.*;

/**
 * Prosty przykad wykorzystania klasy CertificateFactory.
 */
public class MultipleCertificateExample
{
    public static void main(String[] args)
        throws Exception
    {
        // utworzenie kluczy
        KeyPair          pair = Utils.generateRSAKeyPair();
        
        // utworzenie strumienia wejciowego
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        
        bOut.write(X509V1CreateExample.generateV1Certificate(pair).getEncoded());
        bOut.write(X509V3CreateExample.generateV3Certificate(pair).getEncoded());
        
        bOut.close();
        
        InputStream in = new ByteArrayInputStream(bOut.toByteArray());
        
        // utworzenie instancji CertificateFactory
        CertificateFactory fact = CertificateFactory.getInstance("X.509","BC");
        
        // wczytanie certyfikatw
        X509Certificate    x509Cert;
        Collection         collection = new ArrayList();
        
        while((x509Cert = (X509Certificate)fact.generateCertificate(in)) != null)
        {
            collection.add(x509Cert);
        }
        
        Iterator it = collection.iterator();
        while (it.hasNext())
        {
            System.out.println("wersja: " + ((X509Certificate)it.next()).getVersion());
        }
    }
}
